/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on a container instance bind mount host volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostVolumeProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<HostVolumeProperties.Builder, HostVolumeProperties> {
    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HostVolumeProperties::sourcePath)).setter(setter(Builder::sourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourcePath;

    private HostVolumeProperties(BuilderImpl builder) {
        this.sourcePath = builder.sourcePath;
    }

    /**
     * <p>
     * When the <code>host</code> parameter is used, specify a <code>sourcePath</code> to declare the path on the host
     * container instance that is presented to the container. If this parameter is empty, then the Docker daemon has
     * assigned a host path for you. If the <code>host</code> parameter contains a <code>sourcePath</code> file
     * location, then the data volume persists at the specified location on the host container instance until you delete
     * it manually. If the <code>sourcePath</code> value does not exist on the host container instance, the Docker
     * daemon creates it. If the location does exist, the contents of the source path folder are exported.
     * </p>
     * <p>
     * If you are using the Fargate launch type, the <code>sourcePath</code> parameter is not supported.
     * </p>
     * 
     * @return When the <code>host</code> parameter is used, specify a <code>sourcePath</code> to declare the path on
     *         the host container instance that is presented to the container. If this parameter is empty, then the
     *         Docker daemon has assigned a host path for you. If the <code>host</code> parameter contains a
     *         <code>sourcePath</code> file location, then the data volume persists at the specified location on the
     *         host container instance until you delete it manually. If the <code>sourcePath</code> value does not exist
     *         on the host container instance, the Docker daemon creates it. If the location does exist, the contents of
     *         the source path folder are exported.</p>
     *         <p>
     *         If you are using the Fargate launch type, the <code>sourcePath</code> parameter is not supported.
     */
    public String sourcePath() {
        return sourcePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourcePath());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostVolumeProperties)) {
            return false;
        }
        HostVolumeProperties other = (HostVolumeProperties) obj;
        return Objects.equals(sourcePath(), other.sourcePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HostVolumeProperties").add("SourcePath", sourcePath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourcePath":
            return Optional.ofNullable(clazz.cast(sourcePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HostVolumeProperties, T> g) {
        return obj -> g.apply((HostVolumeProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostVolumeProperties> {
        /**
         * <p>
         * When the <code>host</code> parameter is used, specify a <code>sourcePath</code> to declare the path on the
         * host container instance that is presented to the container. If this parameter is empty, then the Docker
         * daemon has assigned a host path for you. If the <code>host</code> parameter contains a
         * <code>sourcePath</code> file location, then the data volume persists at the specified location on the host
         * container instance until you delete it manually. If the <code>sourcePath</code> value does not exist on the
         * host container instance, the Docker daemon creates it. If the location does exist, the contents of the source
         * path folder are exported.
         * </p>
         * <p>
         * If you are using the Fargate launch type, the <code>sourcePath</code> parameter is not supported.
         * </p>
         * 
         * @param sourcePath
         *        When the <code>host</code> parameter is used, specify a <code>sourcePath</code> to declare the path on
         *        the host container instance that is presented to the container. If this parameter is empty, then the
         *        Docker daemon has assigned a host path for you. If the <code>host</code> parameter contains a
         *        <code>sourcePath</code> file location, then the data volume persists at the specified location on the
         *        host container instance until you delete it manually. If the <code>sourcePath</code> value does not
         *        exist on the host container instance, the Docker daemon creates it. If the location does exist, the
         *        contents of the source path folder are exported.</p>
         *        <p>
         *        If you are using the Fargate launch type, the <code>sourcePath</code> parameter is not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String sourcePath);
    }

    static final class BuilderImpl implements Builder {
        private String sourcePath;

        private BuilderImpl() {
        }

        private BuilderImpl(HostVolumeProperties model) {
            sourcePath(model.sourcePath);
        }

        public final String getSourcePath() {
            return sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public HostVolumeProperties build() {
            return new HostVolumeProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
