/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on a service within a cluster
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements SdkPojo, Serializable, ToCopyableBuilder<Service.Builder, Service> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::serviceArn)).setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<List<LoadBalancer>> LOAD_BALANCERS_FIELD = SdkField
            .<List<LoadBalancer>> builder(MarshallingType.LIST)
            .getter(getter(Service::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ServiceRegistry>> SERVICE_REGISTRIES_FIELD = SdkField
            .<List<ServiceRegistry>> builder(MarshallingType.LIST)
            .getter(getter(Service::serviceRegistries))
            .setter(setter(Builder::serviceRegistries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRegistries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceRegistry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceRegistry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Service::desiredCount)).setter(setter(Builder::desiredCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredCount").build()).build();

    private static final SdkField<Integer> RUNNING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Service::runningCount)).setter(setter(Builder::runningCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningCount").build()).build();

    private static final SdkField<Integer> PENDING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Service::pendingCount)).setter(setter(Builder::pendingCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingCount").build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::launchTypeAsString)).setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchType").build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::platformVersion)).setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersion").build()).build();

    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::taskDefinition)).setter(setter(Builder::taskDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinition").build()).build();

    private static final SdkField<DeploymentConfiguration> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<DeploymentConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(Service::deploymentConfiguration))
            .setter(setter(Builder::deploymentConfiguration)).constructor(DeploymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfiguration").build())
            .build();

    private static final SdkField<List<TaskSet>> TASK_SETS_FIELD = SdkField
            .<List<TaskSet>> builder(MarshallingType.LIST)
            .getter(getter(Service::taskSets))
            .setter(setter(Builder::taskSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TaskSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(TaskSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Deployment>> DEPLOYMENTS_FIELD = SdkField
            .<List<Deployment>> builder(MarshallingType.LIST)
            .getter(getter(Service::deployments))
            .setter(setter(Builder::deployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Deployment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Deployment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<ServiceEvent>> EVENTS_FIELD = SdkField
            .<List<ServiceEvent>> builder(MarshallingType.LIST)
            .getter(getter(Service::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Service::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<List<PlacementConstraint>> PLACEMENT_CONSTRAINTS_FIELD = SdkField
            .<List<PlacementConstraint>> builder(MarshallingType.LIST)
            .getter(getter(Service::placementConstraints))
            .setter(setter(Builder::placementConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementConstraint> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementConstraint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PlacementStrategy>> PLACEMENT_STRATEGY_FIELD = SdkField
            .<List<PlacementStrategy>> builder(MarshallingType.LIST)
            .getter(getter(Service::placementStrategy))
            .setter(setter(Builder::placementStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placementStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlacementStrategy> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlacementStrategy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(Service::networkConfiguration))
            .setter(setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Service::healthCheckGracePeriodSeconds))
            .setter(setter(Builder::healthCheckGracePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckGracePeriodSeconds")
                    .build()).build();

    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::schedulingStrategyAsString)).setter(setter(Builder::schedulingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulingStrategy").build())
            .build();

    private static final SdkField<DeploymentController> DEPLOYMENT_CONTROLLER_FIELD = SdkField
            .<DeploymentController> builder(MarshallingType.SDK_POJO).getter(getter(Service::deploymentController))
            .setter(setter(Builder::deploymentController)).constructor(DeploymentController::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentController").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(Service::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Service::enableECSManagedTags)).setter(setter(Builder::enableECSManagedTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableECSManagedTags").build())
            .build();

    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Service::propagateTagsAsString)).setter(setter(Builder::propagateTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagateTags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD,
            SERVICE_NAME_FIELD, CLUSTER_ARN_FIELD, LOAD_BALANCERS_FIELD, SERVICE_REGISTRIES_FIELD, STATUS_FIELD,
            DESIRED_COUNT_FIELD, RUNNING_COUNT_FIELD, PENDING_COUNT_FIELD, LAUNCH_TYPE_FIELD, PLATFORM_VERSION_FIELD,
            TASK_DEFINITION_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, TASK_SETS_FIELD, DEPLOYMENTS_FIELD, ROLE_ARN_FIELD,
            EVENTS_FIELD, CREATED_AT_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGY_FIELD, NETWORK_CONFIGURATION_FIELD,
            HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD, SCHEDULING_STRATEGY_FIELD, DEPLOYMENT_CONTROLLER_FIELD, TAGS_FIELD,
            CREATED_BY_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD, PROPAGATE_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceArn;

    private final String serviceName;

    private final String clusterArn;

    private final List<LoadBalancer> loadBalancers;

    private final List<ServiceRegistry> serviceRegistries;

    private final String status;

    private final Integer desiredCount;

    private final Integer runningCount;

    private final Integer pendingCount;

    private final String launchType;

    private final String platformVersion;

    private final String taskDefinition;

    private final DeploymentConfiguration deploymentConfiguration;

    private final List<TaskSet> taskSets;

    private final List<Deployment> deployments;

    private final String roleArn;

    private final List<ServiceEvent> events;

    private final Instant createdAt;

    private final List<PlacementConstraint> placementConstraints;

    private final List<PlacementStrategy> placementStrategy;

    private final NetworkConfiguration networkConfiguration;

    private final Integer healthCheckGracePeriodSeconds;

    private final String schedulingStrategy;

    private final DeploymentController deploymentController;

    private final List<Tag> tags;

    private final String createdBy;

    private final Boolean enableECSManagedTags;

    private final String propagateTags;

    private Service(BuilderImpl builder) {
        this.serviceArn = builder.serviceArn;
        this.serviceName = builder.serviceName;
        this.clusterArn = builder.clusterArn;
        this.loadBalancers = builder.loadBalancers;
        this.serviceRegistries = builder.serviceRegistries;
        this.status = builder.status;
        this.desiredCount = builder.desiredCount;
        this.runningCount = builder.runningCount;
        this.pendingCount = builder.pendingCount;
        this.launchType = builder.launchType;
        this.platformVersion = builder.platformVersion;
        this.taskDefinition = builder.taskDefinition;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.taskSets = builder.taskSets;
        this.deployments = builder.deployments;
        this.roleArn = builder.roleArn;
        this.events = builder.events;
        this.createdAt = builder.createdAt;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategy = builder.placementStrategy;
        this.networkConfiguration = builder.networkConfiguration;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.deploymentController = builder.deploymentController;
        this.tags = builder.tags;
        this.createdBy = builder.createdBy;
        this.enableECSManagedTags = builder.enableECSManagedTags;
        this.propagateTags = builder.propagateTags;
    }

    /**
     * <p>
     * The ARN that identifies the service. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the
     * Region of the service, the AWS account ID of the service owner, the <code>service</code> namespace, and then the
     * service name. For example, <code>arn:aws:ecs:region:012345678910:service/my-service</code>.
     * </p>
     * 
     * @return The ARN that identifies the service. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by
     *         the Region of the service, the AWS account ID of the service owner, the <code>service</code> namespace,
     *         and then the service name. For example, <code>arn:aws:ecs:region:012345678910:service/my-service</code>.
     */
    public String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, and hyphens are allowed. Service
     * names must be unique within a cluster, but you can have similarly named services in multiple clusters within a
     * Region or across multiple Regions.
     * </p>
     * 
     * @return The name of your service. Up to 255 letters (uppercase and lowercase), numbers, and hyphens are allowed.
     *         Service names must be unique within a cluster, but you can have similarly named services in multiple
     *         clusters within a Region or across multiple Regions.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the cluster that hosts the service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the cluster that hosts the service.
     */
    public String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as
     * it appears in a container definition), and the container port to access from the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container
     *         name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    public List<LoadBalancer> loadBalancers() {
        return loadBalancers;
    }

    /**
     * <p>
     * The details of the service discovery registries to assign to this service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service Discovery</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The details of the service discovery registries to assign to this service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
     *         Discovery</a>.
     */
    public List<ServiceRegistry> serviceRegistries() {
        return serviceRegistries;
    }

    /**
     * <p>
     * The status of the service. The valid values are <code>ACTIVE</code>, <code>DRAINING</code>, or
     * <code>INACTIVE</code>.
     * </p>
     * 
     * @return The status of the service. The valid values are <code>ACTIVE</code>, <code>DRAINING</code>, or
     *         <code>INACTIVE</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The desired number of instantiations of the task definition to keep running on the service. This value is
     * specified when the service is created with <a>CreateService</a>, and it can be modified with
     * <a>UpdateService</a>.
     * </p>
     * 
     * @return The desired number of instantiations of the task definition to keep running on the service. This value is
     *         specified when the service is created with <a>CreateService</a>, and it can be modified with
     *         <a>UpdateService</a>.
     */
    public Integer desiredCount() {
        return desiredCount;
    }

    /**
     * <p>
     * The number of tasks in the cluster that are in the <code>RUNNING</code> state.
     * </p>
     * 
     * @return The number of tasks in the cluster that are in the <code>RUNNING</code> state.
     */
    public Integer runningCount() {
        return runningCount;
    }

    /**
     * <p>
     * The number of tasks in the cluster that are in the <code>PENDING</code> state.
     * </p>
     * 
     * @return The number of tasks in the cluster that are in the <code>PENDING</code> state.
     */
    public Integer pendingCount() {
        return pendingCount;
    }

    /**
     * <p>
     * The launch type on which your service is running. If no value is specified, it will default to <code>EC2</code>.
     * Valid values include <code>EC2</code> and <code>FARGATE</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type on which your service is running. If no value is specified, it will default to
     *         <code>EC2</code>. Valid values include <code>EC2</code> and <code>FARGATE</code>. For more information,
     *         see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
     *         Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @see LaunchType
     */
    public LaunchType launchType() {
        return LaunchType.fromValue(launchType);
    }

    /**
     * <p>
     * The launch type on which your service is running. If no value is specified, it will default to <code>EC2</code>.
     * Valid values include <code>EC2</code> and <code>FARGATE</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchType} will
     * return {@link LaunchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchTypeAsString}.
     * </p>
     * 
     * @return The launch type on which your service is running. If no value is specified, it will default to
     *         <code>EC2</code>. Valid values include <code>EC2</code> and <code>FARGATE</code>. For more information,
     *         see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS
     *         Launch Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @see LaunchType
     */
    public String launchTypeAsString() {
        return launchType;
    }

    /**
     * <p>
     * The platform version on which to run your service. A platform version is only specified for tasks using the
     * Fargate launch type. If one is not specified, the <code>LATEST</code> platform version is used by default. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The platform version on which to run your service. A platform version is only specified for tasks using
     *         the Fargate launch type. If one is not specified, the <code>LATEST</code> platform version is used by
     *         default. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
     *         Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * The task definition to use for tasks in the service. This value is specified when the service is created with
     * <a>CreateService</a>, and it can be modified with <a>UpdateService</a>.
     * </p>
     * 
     * @return The task definition to use for tasks in the service. This value is specified when the service is created
     *         with <a>CreateService</a>, and it can be modified with <a>UpdateService</a>.
     */
    public String taskDefinition() {
        return taskDefinition;
    }

    /**
     * <p>
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping
     * and starting tasks.
     * </p>
     * 
     * @return Optional deployment parameters that control how many tasks run during the deployment and the ordering of
     *         stopping and starting tasks.
     */
    public DeploymentConfiguration deploymentConfiguration() {
        return deploymentConfiguration;
    }

    /**
     * <p>
     * Information about a set of Amazon ECS tasks in either an AWS CodeDeploy or an <code>EXTERNAL</code> deployment.
     * An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are running, and
     * whether the task set serves production traffic.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about a set of Amazon ECS tasks in either an AWS CodeDeploy or an <code>EXTERNAL</code>
     *         deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many tasks
     *         are running, and whether the task set serves production traffic.
     */
    public List<TaskSet> taskSets() {
        return taskSets;
    }

    /**
     * <p>
     * The current state of deployments for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The current state of deployments for the service.
     */
    public List<Deployment> deployments() {
        return deployments;
    }

    /**
     * <p>
     * The ARN of the IAM role associated with the service that allows the Amazon ECS container agent to register
     * container instances with an Elastic Load Balancing load balancer.
     * </p>
     * 
     * @return The ARN of the IAM role associated with the service that allows the Amazon ECS container agent to
     *         register container instances with an Elastic Load Balancing load balancer.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The event stream for your service. A maximum of 100 of the latest events are displayed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The event stream for your service. A maximum of 100 of the latest events are displayed.
     */
    public List<ServiceEvent> events() {
        return events;
    }

    /**
     * <p>
     * The Unix timestamp for when the service was created.
     * </p>
     * 
     * @return The Unix timestamp for when the service was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The placement constraints for the tasks in the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The placement constraints for the tasks in the service.
     */
    public List<PlacementConstraint> placementConstraints() {
        return placementConstraints;
    }

    /**
     * <p>
     * The placement strategy that determines how tasks for the service are placed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The placement strategy that determines how tasks for the service are placed.
     */
    public List<PlacementStrategy> placementStrategy() {
        return placementStrategy;
    }

    /**
     * <p>
     * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by
     * using the <code>awsvpc</code> networking mode.
     * </p>
     * 
     * @return The VPC subnet and security group configuration for tasks that receive their own elastic network
     *         interface by using the <code>awsvpc</code> networking mode.
     */
    public NetworkConfiguration networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * <p>
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing
     * target health checks after a task has first started.
     * </p>
     * 
     * @return The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
     *         Balancing target health checks after a task has first started.
     */
    public Integer healthCheckGracePeriodSeconds() {
        return healthCheckGracePeriodSeconds;
    }

    /**
     * <p>
     * The scheduling strategy to use for the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
     * </p>
     * <p>
     * There are two service scheduler strategies available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your
     * cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement
     * strategies and constraints to customize task placement decisions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each container instance in your
     * cluster. When you are using this strategy, do not specify a desired number of tasks or any task placement
     * strategies.
     * </p>
     * <note>
     * <p>
     * Fargate tasks do not support the <code>DAEMON</code> scheduling strategy.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy to use for the service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
     *         <p>
     *         There are two service scheduler strategies available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
     *         across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can
     *         use task placement strategies and constraints to customize task placement decisions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each container instance in
     *         your cluster. When you are using this strategy, do not specify a desired number of tasks or any task
     *         placement strategies.
     *         </p>
     *         <note>
     *         <p>
     *         Fargate tasks do not support the <code>DAEMON</code> scheduling strategy.
     *         </p>
     *         </note></li>
     * @see SchedulingStrategy
     */
    public SchedulingStrategy schedulingStrategy() {
        return SchedulingStrategy.fromValue(schedulingStrategy);
    }

    /**
     * <p>
     * The scheduling strategy to use for the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
     * </p>
     * <p>
     * There are two service scheduler strategies available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across your
     * cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement
     * strategies and constraints to customize task placement decisions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each container instance in your
     * cluster. When you are using this strategy, do not specify a desired number of tasks or any task placement
     * strategies.
     * </p>
     * <note>
     * <p>
     * Fargate tasks do not support the <code>DAEMON</code> scheduling strategy.
     * </p>
     * </note></li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #schedulingStrategy} will return {@link SchedulingStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #schedulingStrategyAsString}.
     * </p>
     * 
     * @return The scheduling strategy to use for the service. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
     *         <p>
     *         There are two service scheduler strategies available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
     *         across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can
     *         use task placement strategies and constraints to customize task placement decisions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each container instance in
     *         your cluster. When you are using this strategy, do not specify a desired number of tasks or any task
     *         placement strategies.
     *         </p>
     *         <note>
     *         <p>
     *         Fargate tasks do not support the <code>DAEMON</code> scheduling strategy.
     *         </p>
     *         </note></li>
     * @see SchedulingStrategy
     */
    public String schedulingStrategyAsString() {
        return schedulingStrategy;
    }

    /**
     * <p>
     * The deployment controller type the service is using. When using the DescribeServices API, this field is omitted
     * if the service is using the <code>ECS</code> deployment controller type.
     * </p>
     * 
     * @return The deployment controller type the service is using. When using the DescribeServices API, this field is
     *         omitted if the service is using the <code>ECS</code> deployment controller type.
     */
    public DeploymentController deploymentController() {
        return deploymentController;
    }

    /**
     * <p>
     * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a key
     * and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with this
     * prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The metadata that you apply to the service to help you categorize and organize them. Each tag consists of
     *         a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or
     *         values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The principal that created the service.
     * </p>
     * 
     * @return The principal that created the service.
     */
    public String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Specifies whether to enable Amazon ECS managed tags for the tasks in the service. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS
     * Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return Specifies whether to enable Amazon ECS managed tags for the tasks in the service. For more information,
     *         see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging
     *         Your Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public Boolean enableECSManagedTags() {
        return enableECSManagedTags;
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the task definition or the service to the task. If no value is
     * specified, the tags are not propagated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Specifies whether to propagate the tags from the task definition or the service to the task. If no value
     *         is specified, the tags are not propagated.
     * @see PropagateTags
     */
    public PropagateTags propagateTags() {
        return PropagateTags.fromValue(propagateTags);
    }

    /**
     * <p>
     * Specifies whether to propagate the tags from the task definition or the service to the task. If no value is
     * specified, the tags are not propagated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #propagateTags}
     * will return {@link PropagateTags#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #propagateTagsAsString}.
     * </p>
     * 
     * @return Specifies whether to propagate the tags from the task definition or the service to the task. If no value
     *         is specified, the tags are not propagated.
     * @see PropagateTags
     */
    public String propagateTagsAsString() {
        return propagateTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancers());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRegistries());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(runningCount());
        hashCode = 31 * hashCode + Objects.hashCode(pendingCount());
        hashCode = 31 * hashCode + Objects.hashCode(launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(taskSets());
        hashCode = 31 * hashCode + Objects.hashCode(deployments());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(events());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(placementConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(placementStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentController());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(enableECSManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(propagateTagsAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(serviceArn(), other.serviceArn()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(loadBalancers(), other.loadBalancers())
                && Objects.equals(serviceRegistries(), other.serviceRegistries()) && Objects.equals(status(), other.status())
                && Objects.equals(desiredCount(), other.desiredCount()) && Objects.equals(runningCount(), other.runningCount())
                && Objects.equals(pendingCount(), other.pendingCount())
                && Objects.equals(launchTypeAsString(), other.launchTypeAsString())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(taskDefinition(), other.taskDefinition())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration())
                && Objects.equals(taskSets(), other.taskSets()) && Objects.equals(deployments(), other.deployments())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(events(), other.events())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(placementConstraints(), other.placementConstraints())
                && Objects.equals(placementStrategy(), other.placementStrategy())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && Objects.equals(healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds())
                && Objects.equals(schedulingStrategyAsString(), other.schedulingStrategyAsString())
                && Objects.equals(deploymentController(), other.deploymentController()) && Objects.equals(tags(), other.tags())
                && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(enableECSManagedTags(), other.enableECSManagedTags())
                && Objects.equals(propagateTagsAsString(), other.propagateTagsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Service").add("ServiceArn", serviceArn()).add("ServiceName", serviceName())
                .add("ClusterArn", clusterArn()).add("LoadBalancers", loadBalancers())
                .add("ServiceRegistries", serviceRegistries()).add("Status", status()).add("DesiredCount", desiredCount())
                .add("RunningCount", runningCount()).add("PendingCount", pendingCount()).add("LaunchType", launchTypeAsString())
                .add("PlatformVersion", platformVersion()).add("TaskDefinition", taskDefinition())
                .add("DeploymentConfiguration", deploymentConfiguration()).add("TaskSets", taskSets())
                .add("Deployments", deployments()).add("RoleArn", roleArn()).add("Events", events())
                .add("CreatedAt", createdAt()).add("PlacementConstraints", placementConstraints())
                .add("PlacementStrategy", placementStrategy()).add("NetworkConfiguration", networkConfiguration())
                .add("HealthCheckGracePeriodSeconds", healthCheckGracePeriodSeconds())
                .add("SchedulingStrategy", schedulingStrategyAsString()).add("DeploymentController", deploymentController())
                .add("Tags", tags()).add("CreatedBy", createdBy()).add("EnableECSManagedTags", enableECSManagedTags())
                .add("PropagateTags", propagateTagsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "loadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        case "serviceRegistries":
            return Optional.ofNullable(clazz.cast(serviceRegistries()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "desiredCount":
            return Optional.ofNullable(clazz.cast(desiredCount()));
        case "runningCount":
            return Optional.ofNullable(clazz.cast(runningCount()));
        case "pendingCount":
            return Optional.ofNullable(clazz.cast(pendingCount()));
        case "launchType":
            return Optional.ofNullable(clazz.cast(launchTypeAsString()));
        case "platformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "taskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        case "deploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        case "taskSets":
            return Optional.ofNullable(clazz.cast(taskSets()));
        case "deployments":
            return Optional.ofNullable(clazz.cast(deployments()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "placementConstraints":
            return Optional.ofNullable(clazz.cast(placementConstraints()));
        case "placementStrategy":
            return Optional.ofNullable(clazz.cast(placementStrategy()));
        case "networkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "healthCheckGracePeriodSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriodSeconds()));
        case "schedulingStrategy":
            return Optional.ofNullable(clazz.cast(schedulingStrategyAsString()));
        case "deploymentController":
            return Optional.ofNullable(clazz.cast(deploymentController()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "enableECSManagedTags":
            return Optional.ofNullable(clazz.cast(enableECSManagedTags()));
        case "propagateTags":
            return Optional.ofNullable(clazz.cast(propagateTagsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * The ARN that identifies the service. The ARN contains the <code>arn:aws:ecs</code> namespace, followed by the
         * Region of the service, the AWS account ID of the service owner, the <code>service</code> namespace, and then
         * the service name. For example, <code>arn:aws:ecs:region:012345678910:service/my-service</code>.
         * </p>
         * 
         * @param serviceArn
         *        The ARN that identifies the service. The ARN contains the <code>arn:aws:ecs</code> namespace, followed
         *        by the Region of the service, the AWS account ID of the service owner, the <code>service</code>
         *        namespace, and then the service name. For example,
         *        <code>arn:aws:ecs:region:012345678910:service/my-service</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * The name of your service. Up to 255 letters (uppercase and lowercase), numbers, and hyphens are allowed.
         * Service names must be unique within a cluster, but you can have similarly named services in multiple clusters
         * within a Region or across multiple Regions.
         * </p>
         * 
         * @param serviceName
         *        The name of your service. Up to 255 letters (uppercase and lowercase), numbers, and hyphens are
         *        allowed. Service names must be unique within a cluster, but you can have similarly named services in
         *        multiple clusters within a Region or across multiple Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the cluster that hosts the service.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name (ARN) of the cluster that hosts the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name
         * (as it appears in a container definition), and the container port to access from the load balancer.
         * </p>
         * 
         * @param loadBalancers
         *        A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the
         *        container name (as it appears in a container definition), and the container port to access from the
         *        load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<LoadBalancer> loadBalancers);

        /**
         * <p>
         * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name
         * (as it appears in a container definition), and the container port to access from the load balancer.
         * </p>
         * 
         * @param loadBalancers
         *        A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the
         *        container name (as it appears in a container definition), and the container port to access from the
         *        load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(LoadBalancer... loadBalancers);

        /**
         * <p>
         * A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name
         * (as it appears in a container definition), and the container port to access from the load balancer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancer>.Builder} avoiding the need to
         * create one manually via {@link List<LoadBalancer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancer>.Builder#build()} is called immediately and its
         * result is passed to {@link #loadBalancers(List<LoadBalancer>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on {@link List<LoadBalancer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(List<LoadBalancer>)
         */
        Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers);

        /**
         * <p>
         * The details of the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * 
         * @param serviceRegistries
         *        The details of the service discovery registries to assign to this service. For more information, see
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries);

        /**
         * <p>
         * The details of the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * 
         * @param serviceRegistries
         *        The details of the service discovery registries to assign to this service. For more information, see
         *        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         *        Discovery</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(ServiceRegistry... serviceRegistries);

        /**
         * <p>
         * The details of the service discovery registries to assign to this service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service
         * Discovery</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceRegistry>.Builder} avoiding the need
         * to create one manually via {@link List<ServiceRegistry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceRegistry>.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceRegistries(List<ServiceRegistry>)}.
         * 
         * @param serviceRegistries
         *        a consumer that will call methods on {@link List<ServiceRegistry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceRegistries(List<ServiceRegistry>)
         */
        Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries);

        /**
         * <p>
         * The status of the service. The valid values are <code>ACTIVE</code>, <code>DRAINING</code>, or
         * <code>INACTIVE</code>.
         * </p>
         * 
         * @param status
         *        The status of the service. The valid values are <code>ACTIVE</code>, <code>DRAINING</code>, or
         *        <code>INACTIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The desired number of instantiations of the task definition to keep running on the service. This value is
         * specified when the service is created with <a>CreateService</a>, and it can be modified with
         * <a>UpdateService</a>.
         * </p>
         * 
         * @param desiredCount
         *        The desired number of instantiations of the task definition to keep running on the service. This value
         *        is specified when the service is created with <a>CreateService</a>, and it can be modified with
         *        <a>UpdateService</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCount(Integer desiredCount);

        /**
         * <p>
         * The number of tasks in the cluster that are in the <code>RUNNING</code> state.
         * </p>
         * 
         * @param runningCount
         *        The number of tasks in the cluster that are in the <code>RUNNING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningCount(Integer runningCount);

        /**
         * <p>
         * The number of tasks in the cluster that are in the <code>PENDING</code> state.
         * </p>
         * 
         * @param pendingCount
         *        The number of tasks in the cluster that are in the <code>PENDING</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingCount(Integer pendingCount);

        /**
         * <p>
         * The launch type on which your service is running. If no value is specified, it will default to
         * <code>EC2</code>. Valid values include <code>EC2</code> and <code>FARGATE</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param launchType
         *        The launch type on which your service is running. If no value is specified, it will default to
         *        <code>EC2</code>. Valid values include <code>EC2</code> and <code>FARGATE</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         *        Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(String launchType);

        /**
         * <p>
         * The launch type on which your service is running. If no value is specified, it will default to
         * <code>EC2</code>. Valid values include <code>EC2</code> and <code>FARGATE</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         * Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param launchType
         *        The launch type on which your service is running. If no value is specified, it will default to
         *        <code>EC2</code>. Valid values include <code>EC2</code> and <code>FARGATE</code>. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch
         *        Types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @see LaunchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchType
         */
        Builder launchType(LaunchType launchType);

        /**
         * <p>
         * The platform version on which to run your service. A platform version is only specified for tasks using the
         * Fargate launch type. If one is not specified, the <code>LATEST</code> platform version is used by default.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
         * Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param platformVersion
         *        The platform version on which to run your service. A platform version is only specified for tasks
         *        using the Fargate launch type. If one is not specified, the <code>LATEST</code> platform version is
         *        used by default. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate
         *        Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * The task definition to use for tasks in the service. This value is specified when the service is created with
         * <a>CreateService</a>, and it can be modified with <a>UpdateService</a>.
         * </p>
         * 
         * @param taskDefinition
         *        The task definition to use for tasks in the service. This value is specified when the service is
         *        created with <a>CreateService</a>, and it can be modified with <a>UpdateService</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(String taskDefinition);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * 
         * @param deploymentConfiguration
         *        Optional deployment parameters that control how many tasks run during the deployment and the ordering
         *        of stopping and starting tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration);

        /**
         * <p>
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of
         * stopping and starting tasks.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentConfiguration.Builder} avoiding the
         * need to create one manually via {@link DeploymentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentConfiguration(DeploymentConfiguration)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link DeploymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(DeploymentConfiguration)
         */
        default Builder deploymentConfiguration(Consumer<DeploymentConfiguration.Builder> deploymentConfiguration) {
            return deploymentConfiguration(DeploymentConfiguration.builder().applyMutation(deploymentConfiguration).build());
        }

        /**
         * <p>
         * Information about a set of Amazon ECS tasks in either an AWS CodeDeploy or an <code>EXTERNAL</code>
         * deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are
         * running, and whether the task set serves production traffic.
         * </p>
         * 
         * @param taskSets
         *        Information about a set of Amazon ECS tasks in either an AWS CodeDeploy or an <code>EXTERNAL</code>
         *        deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many
         *        tasks are running, and whether the task set serves production traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSets(Collection<TaskSet> taskSets);

        /**
         * <p>
         * Information about a set of Amazon ECS tasks in either an AWS CodeDeploy or an <code>EXTERNAL</code>
         * deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are
         * running, and whether the task set serves production traffic.
         * </p>
         * 
         * @param taskSets
         *        Information about a set of Amazon ECS tasks in either an AWS CodeDeploy or an <code>EXTERNAL</code>
         *        deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many
         *        tasks are running, and whether the task set serves production traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSets(TaskSet... taskSets);

        /**
         * <p>
         * Information about a set of Amazon ECS tasks in either an AWS CodeDeploy or an <code>EXTERNAL</code>
         * deployment. An Amazon ECS task set includes details such as the desired number of tasks, how many tasks are
         * running, and whether the task set serves production traffic.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TaskSet>.Builder} avoiding the need to
         * create one manually via {@link List<TaskSet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TaskSet>.Builder#build()} is called immediately and its
         * result is passed to {@link #taskSets(List<TaskSet>)}.
         * 
         * @param taskSets
         *        a consumer that will call methods on {@link List<TaskSet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskSets(List<TaskSet>)
         */
        Builder taskSets(Consumer<TaskSet.Builder>... taskSets);

        /**
         * <p>
         * The current state of deployments for the service.
         * </p>
         * 
         * @param deployments
         *        The current state of deployments for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(Collection<Deployment> deployments);

        /**
         * <p>
         * The current state of deployments for the service.
         * </p>
         * 
         * @param deployments
         *        The current state of deployments for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(Deployment... deployments);

        /**
         * <p>
         * The current state of deployments for the service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Deployment>.Builder} avoiding the need to
         * create one manually via {@link List<Deployment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Deployment>.Builder#build()} is called immediately and its
         * result is passed to {@link #deployments(List<Deployment>)}.
         * 
         * @param deployments
         *        a consumer that will call methods on {@link List<Deployment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployments(List<Deployment>)
         */
        Builder deployments(Consumer<Deployment.Builder>... deployments);

        /**
         * <p>
         * The ARN of the IAM role associated with the service that allows the Amazon ECS container agent to register
         * container instances with an Elastic Load Balancing load balancer.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role associated with the service that allows the Amazon ECS container agent to
         *        register container instances with an Elastic Load Balancing load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The event stream for your service. A maximum of 100 of the latest events are displayed.
         * </p>
         * 
         * @param events
         *        The event stream for your service. A maximum of 100 of the latest events are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<ServiceEvent> events);

        /**
         * <p>
         * The event stream for your service. A maximum of 100 of the latest events are displayed.
         * </p>
         * 
         * @param events
         *        The event stream for your service. A maximum of 100 of the latest events are displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(ServiceEvent... events);

        /**
         * <p>
         * The event stream for your service. A maximum of 100 of the latest events are displayed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceEvent>.Builder} avoiding the need to
         * create one manually via {@link List<ServiceEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceEvent>.Builder#build()} is called immediately and its
         * result is passed to {@link #events(List<ServiceEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<ServiceEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<ServiceEvent>)
         */
        Builder events(Consumer<ServiceEvent.Builder>... events);

        /**
         * <p>
         * The Unix timestamp for when the service was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp for when the service was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The placement constraints for the tasks in the service.
         * </p>
         * 
         * @param placementConstraints
         *        The placement constraints for the tasks in the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(Collection<PlacementConstraint> placementConstraints);

        /**
         * <p>
         * The placement constraints for the tasks in the service.
         * </p>
         * 
         * @param placementConstraints
         *        The placement constraints for the tasks in the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(PlacementConstraint... placementConstraints);

        /**
         * <p>
         * The placement constraints for the tasks in the service.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlacementConstraint>.Builder} avoiding the
         * need to create one manually via {@link List<PlacementConstraint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlacementConstraint>.Builder#build()} is called immediately
         * and its result is passed to {@link #placementConstraints(List<PlacementConstraint>)}.
         * 
         * @param placementConstraints
         *        a consumer that will call methods on {@link List<PlacementConstraint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementConstraints(List<PlacementConstraint>)
         */
        Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints);

        /**
         * <p>
         * The placement strategy that determines how tasks for the service are placed.
         * </p>
         * 
         * @param placementStrategy
         *        The placement strategy that determines how tasks for the service are placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(Collection<PlacementStrategy> placementStrategy);

        /**
         * <p>
         * The placement strategy that determines how tasks for the service are placed.
         * </p>
         * 
         * @param placementStrategy
         *        The placement strategy that determines how tasks for the service are placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategy(PlacementStrategy... placementStrategy);

        /**
         * <p>
         * The placement strategy that determines how tasks for the service are placed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlacementStrategy>.Builder} avoiding the
         * need to create one manually via {@link List<PlacementStrategy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlacementStrategy>.Builder#build()} is called immediately
         * and its result is passed to {@link #placementStrategy(List<PlacementStrategy>)}.
         * 
         * @param placementStrategy
         *        a consumer that will call methods on {@link List<PlacementStrategy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementStrategy(List<PlacementStrategy>)
         */
        Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy);

        /**
         * <p>
         * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by
         * using the <code>awsvpc</code> networking mode.
         * </p>
         * 
         * @param networkConfiguration
         *        The VPC subnet and security group configuration for tasks that receive their own elastic network
         *        interface by using the <code>awsvpc</code> networking mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(NetworkConfiguration networkConfiguration);

        /**
         * <p>
         * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by
         * using the <code>awsvpc</code> networking mode.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkConfiguration.Builder} avoiding the need
         * to create one manually via {@link NetworkConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #networkConfiguration(NetworkConfiguration)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link NetworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(NetworkConfiguration)
         */
        default Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return networkConfiguration(NetworkConfiguration.builder().applyMutation(networkConfiguration).build());
        }

        /**
         * <p>
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
         * Balancing target health checks after a task has first started.
         * </p>
         * 
         * @param healthCheckGracePeriodSeconds
         *        The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load
         *        Balancing target health checks after a task has first started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds);

        /**
         * <p>
         * The scheduling strategy to use for the service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
         * </p>
         * <p>
         * There are two service scheduler strategies available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across
         * your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task
         * placement strategies and constraints to customize task placement decisions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each container instance in
         * your cluster. When you are using this strategy, do not specify a desired number of tasks or any task
         * placement strategies.
         * </p>
         * <note>
         * <p>
         * Fargate tasks do not support the <code>DAEMON</code> scheduling strategy.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use for the service. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
         *        <p>
         *        There are two service scheduler strategies available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
         *        across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You
         *        can use task placement strategies and constraints to customize task placement decisions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each container instance
         *        in your cluster. When you are using this strategy, do not specify a desired number of tasks or any
         *        task placement strategies.
         *        </p>
         *        <note>
         *        <p>
         *        Fargate tasks do not support the <code>DAEMON</code> scheduling strategy.
         *        </p>
         *        </note></li>
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(String schedulingStrategy);

        /**
         * <p>
         * The scheduling strategy to use for the service. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.
         * </p>
         * <p>
         * There are two service scheduler strategies available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks across
         * your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task
         * placement strategies and constraints to customize task placement decisions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each container instance in
         * your cluster. When you are using this strategy, do not specify a desired number of tasks or any task
         * placement strategies.
         * </p>
         * <note>
         * <p>
         * Fargate tasks do not support the <code>DAEMON</code> scheduling strategy.
         * </p>
         * </note></li>
         * </ul>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use for the service. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a>.</p>
         *        <p>
         *        There are two service scheduler strategies available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>REPLICA</code>-The replica scheduling strategy places and maintains the desired number of tasks
         *        across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You
         *        can use task placement strategies and constraints to customize task placement decisions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DAEMON</code>-The daemon scheduling strategy deploys exactly one task on each container instance
         *        in your cluster. When you are using this strategy, do not specify a desired number of tasks or any
         *        task placement strategies.
         *        </p>
         *        <note>
         *        <p>
         *        Fargate tasks do not support the <code>DAEMON</code> scheduling strategy.
         *        </p>
         *        </note></li>
         * @see SchedulingStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulingStrategy
         */
        Builder schedulingStrategy(SchedulingStrategy schedulingStrategy);

        /**
         * <p>
         * The deployment controller type the service is using. When using the DescribeServices API, this field is
         * omitted if the service is using the <code>ECS</code> deployment controller type.
         * </p>
         * 
         * @param deploymentController
         *        The deployment controller type the service is using. When using the DescribeServices API, this field
         *        is omitted if the service is using the <code>ECS</code> deployment controller type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentController(DeploymentController deploymentController);

        /**
         * <p>
         * The deployment controller type the service is using. When using the DescribeServices API, this field is
         * omitted if the service is using the <code>ECS</code> deployment controller type.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentController.Builder} avoiding the need
         * to create one manually via {@link DeploymentController#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentController.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentController(DeploymentController)}.
         * 
         * @param deploymentController
         *        a consumer that will call methods on {@link DeploymentController.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentController(DeploymentController)
         */
        default Builder deploymentController(Consumer<DeploymentController.Builder> deploymentController) {
            return deploymentController(DeploymentController.builder().applyMutation(deploymentController).build());
        }

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with
         * this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the service to help you categorize and organize them. Each tag consists
         *        of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or
         *        values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with
         * this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The metadata that you apply to the service to help you categorize and organize them. Each tag consists
         *        of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or
         *        values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The metadata that you apply to the service to help you categorize and organize them. Each tag consists of a
         * key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for either keys or values as it is reserved for AWS use. You cannot edit or delete tag keys or values with
         * this prefix. Tags with this prefix do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The principal that created the service.
         * </p>
         * 
         * @param createdBy
         *        The principal that created the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * Specifies whether to enable Amazon ECS managed tags for the tasks in the service. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon
         * ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param enableECSManagedTags
         *        Specifies whether to enable Amazon ECS managed tags for the tasks in the service. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your
         *        Amazon ECS Resources</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableECSManagedTags(Boolean enableECSManagedTags);

        /**
         * <p>
         * Specifies whether to propagate the tags from the task definition or the service to the task. If no value is
         * specified, the tags are not propagated.
         * </p>
         * 
         * @param propagateTags
         *        Specifies whether to propagate the tags from the task definition or the service to the task. If no
         *        value is specified, the tags are not propagated.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(String propagateTags);

        /**
         * <p>
         * Specifies whether to propagate the tags from the task definition or the service to the task. If no value is
         * specified, the tags are not propagated.
         * </p>
         * 
         * @param propagateTags
         *        Specifies whether to propagate the tags from the task definition or the service to the task. If no
         *        value is specified, the tags are not propagated.
         * @see PropagateTags
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PropagateTags
         */
        Builder propagateTags(PropagateTags propagateTags);
    }

    static final class BuilderImpl implements Builder {
        private String serviceArn;

        private String serviceName;

        private String clusterArn;

        private List<LoadBalancer> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private List<ServiceRegistry> serviceRegistries = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Integer desiredCount;

        private Integer runningCount;

        private Integer pendingCount;

        private String launchType;

        private String platformVersion;

        private String taskDefinition;

        private DeploymentConfiguration deploymentConfiguration;

        private List<TaskSet> taskSets = DefaultSdkAutoConstructList.getInstance();

        private List<Deployment> deployments = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private List<ServiceEvent> events = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private List<PlacementConstraint> placementConstraints = DefaultSdkAutoConstructList.getInstance();

        private List<PlacementStrategy> placementStrategy = DefaultSdkAutoConstructList.getInstance();

        private NetworkConfiguration networkConfiguration;

        private Integer healthCheckGracePeriodSeconds;

        private String schedulingStrategy;

        private DeploymentController deploymentController;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String createdBy;

        private Boolean enableECSManagedTags;

        private String propagateTags;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            serviceArn(model.serviceArn);
            serviceName(model.serviceName);
            clusterArn(model.clusterArn);
            loadBalancers(model.loadBalancers);
            serviceRegistries(model.serviceRegistries);
            status(model.status);
            desiredCount(model.desiredCount);
            runningCount(model.runningCount);
            pendingCount(model.pendingCount);
            launchType(model.launchType);
            platformVersion(model.platformVersion);
            taskDefinition(model.taskDefinition);
            deploymentConfiguration(model.deploymentConfiguration);
            taskSets(model.taskSets);
            deployments(model.deployments);
            roleArn(model.roleArn);
            events(model.events);
            createdAt(model.createdAt);
            placementConstraints(model.placementConstraints);
            placementStrategy(model.placementStrategy);
            networkConfiguration(model.networkConfiguration);
            healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            schedulingStrategy(model.schedulingStrategy);
            deploymentController(model.deploymentController);
            tags(model.tags);
            createdBy(model.createdBy);
            enableECSManagedTags(model.enableECSManagedTags);
            propagateTags(model.propagateTags);
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final Collection<LoadBalancer.Builder> getLoadBalancers() {
            return loadBalancers != null ? loadBalancers.stream().map(LoadBalancer::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancer> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancer... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<LoadBalancer.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> LoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancer.BuilderImpl> loadBalancers) {
            this.loadBalancers = LoadBalancersCopier.copyFromBuilder(loadBalancers);
        }

        public final Collection<ServiceRegistry.Builder> getServiceRegistries() {
            return serviceRegistries != null ? serviceRegistries.stream().map(ServiceRegistry::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceRegistries(Collection<ServiceRegistry> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(ServiceRegistry... serviceRegistries) {
            serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<ServiceRegistry.Builder>... serviceRegistries) {
            serviceRegistries(Stream.of(serviceRegistries).map(c -> ServiceRegistry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServiceRegistries(Collection<ServiceRegistry.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = ServiceRegistriesCopier.copyFromBuilder(serviceRegistries);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getDesiredCount() {
            return desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        public final Integer getRunningCount() {
            return runningCount;
        }

        @Override
        public final Builder runningCount(Integer runningCount) {
            this.runningCount = runningCount;
            return this;
        }

        public final void setRunningCount(Integer runningCount) {
            this.runningCount = runningCount;
        }

        public final Integer getPendingCount() {
            return pendingCount;
        }

        @Override
        public final Builder pendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
            return this;
        }

        public final void setPendingCount(Integer pendingCount) {
            this.pendingCount = pendingCount;
        }

        public final String getLaunchTypeAsString() {
            return launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getTaskDefinition() {
            return taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        public final DeploymentConfiguration.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder deploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final void setDeploymentConfiguration(DeploymentConfiguration.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        public final Collection<TaskSet.Builder> getTaskSets() {
            return taskSets != null ? taskSets.stream().map(TaskSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder taskSets(Collection<TaskSet> taskSets) {
            this.taskSets = TaskSetsCopier.copy(taskSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSets(TaskSet... taskSets) {
            taskSets(Arrays.asList(taskSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSets(Consumer<TaskSet.Builder>... taskSets) {
            taskSets(Stream.of(taskSets).map(c -> TaskSet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTaskSets(Collection<TaskSet.BuilderImpl> taskSets) {
            this.taskSets = TaskSetsCopier.copyFromBuilder(taskSets);
        }

        public final Collection<Deployment.Builder> getDeployments() {
            return deployments != null ? deployments.stream().map(Deployment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Deployment... deployments) {
            deployments(Arrays.asList(deployments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Consumer<Deployment.Builder>... deployments) {
            deployments(Stream.of(deployments).map(c -> Deployment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDeployments(Collection<Deployment.BuilderImpl> deployments) {
            this.deployments = DeploymentsCopier.copyFromBuilder(deployments);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<ServiceEvent.Builder> getEvents() {
            return events != null ? events.stream().map(ServiceEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<ServiceEvent> events) {
            this.events = ServiceEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(ServiceEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<ServiceEvent.Builder>... events) {
            events(Stream.of(events).map(c -> ServiceEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<ServiceEvent.BuilderImpl> events) {
            this.events = ServiceEventsCopier.copyFromBuilder(events);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Collection<PlacementConstraint.Builder> getPlacementConstraints() {
            return placementConstraints != null ? placementConstraints.stream().map(PlacementConstraint::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementConstraints(Collection<PlacementConstraint> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(PlacementConstraint... placementConstraints) {
            placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(Consumer<PlacementConstraint.Builder>... placementConstraints) {
            placementConstraints(Stream.of(placementConstraints).map(c -> PlacementConstraint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementConstraints(Collection<PlacementConstraint.BuilderImpl> placementConstraints) {
            this.placementConstraints = PlacementConstraintsCopier.copyFromBuilder(placementConstraints);
        }

        public final Collection<PlacementStrategy.Builder> getPlacementStrategy() {
            return placementStrategy != null ? placementStrategy.stream().map(PlacementStrategy::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder placementStrategy(Collection<PlacementStrategy> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copy(placementStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(PlacementStrategy... placementStrategy) {
            placementStrategy(Arrays.asList(placementStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategy(Consumer<PlacementStrategy.Builder>... placementStrategy) {
            placementStrategy(Stream.of(placementStrategy).map(c -> PlacementStrategy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlacementStrategy(Collection<PlacementStrategy.BuilderImpl> placementStrategy) {
            this.placementStrategy = PlacementStrategiesCopier.copyFromBuilder(placementStrategy);
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        public final String getSchedulingStrategyAsString() {
            return schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        @Override
        public final Builder schedulingStrategy(SchedulingStrategy schedulingStrategy) {
            this.schedulingStrategy(schedulingStrategy == null ? null : schedulingStrategy.toString());
            return this;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        public final DeploymentController.Builder getDeploymentController() {
            return deploymentController != null ? deploymentController.toBuilder() : null;
        }

        @Override
        public final Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public final void setDeploymentController(DeploymentController.BuilderImpl deploymentController) {
            this.deploymentController = deploymentController != null ? deploymentController.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Boolean getEnableECSManagedTags() {
            return enableECSManagedTags;
        }

        @Override
        public final Builder enableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
            return this;
        }

        public final void setEnableECSManagedTags(Boolean enableECSManagedTags) {
            this.enableECSManagedTags = enableECSManagedTags;
        }

        public final String getPropagateTagsAsString() {
            return propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        @Override
        public final Builder propagateTags(PropagateTags propagateTags) {
            this.propagateTags(propagateTags == null ? null : propagateTags.toString());
            return this;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public Service build() {
            return new Service(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
