/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceResponse extends EcsResponse implements
        ToCopyableBuilder<UpdateServiceResponse.Builder, UpdateServiceResponse> {
    private static final SdkField<Service> SERVICE_FIELD = SdkField.<Service> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateServiceResponse::service)).setter(setter(Builder::service)).constructor(Service::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD));

    private final Service service;

    private UpdateServiceResponse(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
    }

    /**
     * <p>
     * The full description of your service following the update call.
     * </p>
     * 
     * @return The full description of your service following the update call.
     */
    public Service service() {
        return service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(service());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceResponse)) {
            return false;
        }
        UpdateServiceResponse other = (UpdateServiceResponse) obj;
        return Objects.equals(service(), other.service());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateServiceResponse").add("Service", service()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceResponse, T> g) {
        return obj -> g.apply((UpdateServiceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceResponse> {
        /**
         * <p>
         * The full description of your service following the update call.
         * </p>
         * 
         * @param service
         *        The full description of your service following the update call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(Service service);

        /**
         * <p>
         * The full description of your service following the update call.
         * </p>
         * This is a convenience that creates an instance of the {@link Service.Builder} avoiding the need to create one
         * manually via {@link Service#builder()}.
         *
         * When the {@link Consumer} completes, {@link Service.Builder#build()} is called immediately and its result is
         * passed to {@link #service(Service)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link Service.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(Service)
         */
        default Builder service(Consumer<Service.Builder> service) {
            return service(Service.builder().applyMutation(service).build());
        }
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private Service service;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceResponse model) {
            super(model);
            service(model.service);
        }

        public final Service.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public UpdateServiceResponse build() {
            return new UpdateServiceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
