/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Docker and Amazon ECS container agent version information about a container instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VersionInfo implements SdkPojo, Serializable, ToCopyableBuilder<VersionInfo.Builder, VersionInfo> {
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VersionInfo::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()).build();

    private static final SdkField<String> AGENT_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VersionInfo::agentHash)).setter(setter(Builder::agentHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentHash").build()).build();

    private static final SdkField<String> DOCKER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VersionInfo::dockerVersion)).setter(setter(Builder::dockerVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSION_FIELD,
            AGENT_HASH_FIELD, DOCKER_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentVersion;

    private final String agentHash;

    private final String dockerVersion;

    private VersionInfo(BuilderImpl builder) {
        this.agentVersion = builder.agentVersion;
        this.agentHash = builder.agentHash;
        this.dockerVersion = builder.dockerVersion;
    }

    /**
     * <p>
     * The version number of the Amazon ECS container agent.
     * </p>
     * 
     * @return The version number of the Amazon ECS container agent.
     */
    public String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The Git commit hash for the Amazon ECS container agent build on the <a
     * href="https://github.com/aws/amazon-ecs-agent/commits/master">amazon-ecs-agent </a> GitHub repository.
     * </p>
     * 
     * @return The Git commit hash for the Amazon ECS container agent build on the <a
     *         href="https://github.com/aws/amazon-ecs-agent/commits/master">amazon-ecs-agent </a> GitHub repository.
     */
    public String agentHash() {
        return agentHash;
    }

    /**
     * <p>
     * The Docker version running on the container instance.
     * </p>
     * 
     * @return The Docker version running on the container instance.
     */
    public String dockerVersion() {
        return dockerVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(agentHash());
        hashCode = 31 * hashCode + Objects.hashCode(dockerVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo) obj;
        return Objects.equals(agentVersion(), other.agentVersion()) && Objects.equals(agentHash(), other.agentHash())
                && Objects.equals(dockerVersion(), other.dockerVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VersionInfo").add("AgentVersion", agentVersion()).add("AgentHash", agentHash())
                .add("DockerVersion", dockerVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "agentHash":
            return Optional.ofNullable(clazz.cast(agentHash()));
        case "dockerVersion":
            return Optional.ofNullable(clazz.cast(dockerVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VersionInfo, T> g) {
        return obj -> g.apply((VersionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VersionInfo> {
        /**
         * <p>
         * The version number of the Amazon ECS container agent.
         * </p>
         * 
         * @param agentVersion
         *        The version number of the Amazon ECS container agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The Git commit hash for the Amazon ECS container agent build on the <a
         * href="https://github.com/aws/amazon-ecs-agent/commits/master">amazon-ecs-agent </a> GitHub repository.
         * </p>
         * 
         * @param agentHash
         *        The Git commit hash for the Amazon ECS container agent build on the <a
         *        href="https://github.com/aws/amazon-ecs-agent/commits/master">amazon-ecs-agent </a> GitHub repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentHash(String agentHash);

        /**
         * <p>
         * The Docker version running on the container instance.
         * </p>
         * 
         * @param dockerVersion
         *        The Docker version running on the container instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerVersion(String dockerVersion);
    }

    static final class BuilderImpl implements Builder {
        private String agentVersion;

        private String agentHash;

        private String dockerVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(VersionInfo model) {
            agentVersion(model.agentVersion);
            agentHash(model.agentHash);
            dockerVersion(model.dockerVersion);
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final String getAgentHash() {
            return agentHash;
        }

        @Override
        public final Builder agentHash(String agentHash) {
            this.agentHash = agentHash;
            return this;
        }

        public final void setAgentHash(String agentHash) {
            this.agentHash = agentHash;
        }

        public final String getDockerVersion() {
            return dockerVersion;
        }

        @Override
        public final Builder dockerVersion(String dockerVersion) {
            this.dockerVersion = dockerVersion;
            return this;
        }

        public final void setDockerVersion(String dockerVersion) {
            this.dockerVersion = dockerVersion;
        }

        @Override
        public VersionInfo build() {
            return new VersionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
