/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ClusterSetting;
import software.amazon.awssdk.services.ecs.model.ClusterSettingsCopier;
import software.amazon.awssdk.services.ecs.model.KeyValuePair;
import software.amazon.awssdk.services.ecs.model.StatisticsCopier;
import software.amazon.awssdk.services.ecs.model.Tag;
import software.amazon.awssdk.services.ecs.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::clusterArn)).setter(Cluster.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::clusterName)).setter(Cluster.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Cluster.getter(Cluster::status)).setter(Cluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Cluster.getter(Cluster::registeredContainerInstancesCount)).setter(Cluster.setter(Builder::registeredContainerInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredContainerInstancesCount").build()}).build();
    private static final SdkField<Integer> RUNNING_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Cluster.getter(Cluster::runningTasksCount)).setter(Cluster.setter(Builder::runningTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runningTasksCount").build()}).build();
    private static final SdkField<Integer> PENDING_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Cluster.getter(Cluster::pendingTasksCount)).setter(Cluster.setter(Builder::pendingTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingTasksCount").build()}).build();
    private static final SdkField<Integer> ACTIVE_SERVICES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Cluster.getter(Cluster::activeServicesCount)).setter(Cluster.setter(Builder::activeServicesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeServicesCount").build()}).build();
    private static final SdkField<List<KeyValuePair>> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Cluster.getter(Cluster::statistics)).setter(Cluster.setter(Builder::statistics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Cluster.getter(Cluster::tags)).setter(Cluster.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ClusterSetting>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Cluster.getter(Cluster::settings)).setter(Cluster.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, STATUS_FIELD, REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD, RUNNING_TASKS_COUNT_FIELD, PENDING_TASKS_COUNT_FIELD, ACTIVE_SERVICES_COUNT_FIELD, STATISTICS_FIELD, TAGS_FIELD, SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final String clusterName;
    private final String status;
    private final Integer registeredContainerInstancesCount;
    private final Integer runningTasksCount;
    private final Integer pendingTasksCount;
    private final Integer activeServicesCount;
    private final List<KeyValuePair> statistics;
    private final List<Tag> tags;
    private final List<ClusterSetting> settings;

    private Cluster(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.status = builder.status;
        this.registeredContainerInstancesCount = builder.registeredContainerInstancesCount;
        this.runningTasksCount = builder.runningTasksCount;
        this.pendingTasksCount = builder.pendingTasksCount;
        this.activeServicesCount = builder.activeServicesCount;
        this.statistics = builder.statistics;
        this.tags = builder.tags;
        this.settings = builder.settings;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String status() {
        return this.status;
    }

    public Integer registeredContainerInstancesCount() {
        return this.registeredContainerInstancesCount;
    }

    public Integer runningTasksCount() {
        return this.runningTasksCount;
    }

    public Integer pendingTasksCount() {
        return this.pendingTasksCount;
    }

    public Integer activeServicesCount() {
        return this.activeServicesCount;
    }

    public List<KeyValuePair> statistics() {
        return this.statistics;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<ClusterSetting> settings() {
        return this.settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredContainerInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeServicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.registeredContainerInstancesCount(), other.registeredContainerInstancesCount()) && Objects.equals(this.runningTasksCount(), other.runningTasksCount()) && Objects.equals(this.pendingTasksCount(), other.pendingTasksCount()) && Objects.equals(this.activeServicesCount(), other.activeServicesCount()) && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.settings(), other.settings());
    }

    public String toString() {
        return ToString.builder((String)"Cluster").add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("Status", (Object)this.status()).add("RegisteredContainerInstancesCount", (Object)this.registeredContainerInstancesCount()).add("RunningTasksCount", (Object)this.runningTasksCount()).add("PendingTasksCount", (Object)this.pendingTasksCount()).add("ActiveServicesCount", (Object)this.activeServicesCount()).add("Statistics", this.statistics()).add("Tags", this.tags()).add("Settings", this.settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "registeredContainerInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.registeredContainerInstancesCount()));
            }
            case "runningTasksCount": {
                return Optional.ofNullable(clazz.cast(this.runningTasksCount()));
            }
            case "pendingTasksCount": {
                return Optional.ofNullable(clazz.cast(this.pendingTasksCount()));
            }
            case "activeServicesCount": {
                return Optional.ofNullable(clazz.cast(this.activeServicesCount()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private String clusterName;
        private String status;
        private Integer registeredContainerInstancesCount;
        private Integer runningTasksCount;
        private Integer pendingTasksCount;
        private Integer activeServicesCount;
        private List<KeyValuePair> statistics = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<ClusterSetting> settings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.status(model.status);
            this.registeredContainerInstancesCount(model.registeredContainerInstancesCount);
            this.runningTasksCount(model.runningTasksCount);
            this.pendingTasksCount(model.pendingTasksCount);
            this.activeServicesCount(model.activeServicesCount);
            this.statistics(model.statistics);
            this.tags(model.tags);
            this.settings(model.settings);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getRegisteredContainerInstancesCount() {
            return this.registeredContainerInstancesCount;
        }

        @Override
        public final Builder registeredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
            return this;
        }

        public final void setRegisteredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
        }

        public final Integer getRunningTasksCount() {
            return this.runningTasksCount;
        }

        @Override
        public final Builder runningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
            return this;
        }

        public final void setRunningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
        }

        public final Integer getPendingTasksCount() {
            return this.pendingTasksCount;
        }

        @Override
        public final Builder pendingTasksCount(Integer pendingTasksCount) {
            this.pendingTasksCount = pendingTasksCount;
            return this;
        }

        public final void setPendingTasksCount(Integer pendingTasksCount) {
            this.pendingTasksCount = pendingTasksCount;
        }

        public final Integer getActiveServicesCount() {
            return this.activeServicesCount;
        }

        @Override
        public final Builder activeServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
            return this;
        }

        public final void setActiveServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
        }

        public final Collection<KeyValuePair.Builder> getStatistics() {
            return this.statistics != null ? (Collection)this.statistics.stream().map(KeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statistics(Collection<KeyValuePair> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(KeyValuePair ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Consumer<KeyValuePair.Builder> ... statistics) {
            this.statistics(Stream.of(statistics).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatistics(Collection<KeyValuePair.BuilderImpl> statistics) {
            this.statistics = StatisticsCopier.copyFromBuilder(statistics);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Collection<ClusterSetting.Builder> getSettings() {
            return this.settings != null ? (Collection)this.settings.stream().map(ClusterSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder settings(Collection<ClusterSetting> settings) {
            this.settings = ClusterSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder settings(ClusterSetting ... settings) {
            this.settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder settings(Consumer<ClusterSetting.Builder> ... settings) {
            this.settings(Stream.of(settings).map(c -> (ClusterSetting)((ClusterSetting.Builder)ClusterSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSettings(Collection<ClusterSetting.BuilderImpl> settings) {
            this.settings = ClusterSettingsCopier.copyFromBuilder(settings);
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder status(String var1);

        public Builder registeredContainerInstancesCount(Integer var1);

        public Builder runningTasksCount(Integer var1);

        public Builder pendingTasksCount(Integer var1);

        public Builder activeServicesCount(Integer var1);

        public Builder statistics(Collection<KeyValuePair> var1);

        public Builder statistics(KeyValuePair ... var1);

        public Builder statistics(Consumer<KeyValuePair.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder settings(Collection<ClusterSetting> var1);

        public Builder settings(ClusterSetting ... var1);

        public Builder settings(Consumer<ClusterSetting.Builder> ... var1);
    }
}

