/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.Failure;
import software.amazon.awssdk.services.ecs.model.FailuresCopier;
import software.amazon.awssdk.services.ecs.model.Service;
import software.amazon.awssdk.services.ecs.model.ServicesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServicesResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, DescribeServicesResponse> {
    private static final SdkField<List<Service>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeServicesResponse.getter(DescribeServicesResponse::services)).setter(DescribeServicesResponse.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Service::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeServicesResponse.getter(DescribeServicesResponse::failures)).setter(DescribeServicesResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Failure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICES_FIELD, FAILURES_FIELD));
    private final List<Service> services;
    private final List<Failure> failures;

    private DescribeServicesResponse(BuilderImpl builder) {
        super(builder);
        this.services = builder.services;
        this.failures = builder.failures;
    }

    public List<Service> services() {
        return this.services;
    }

    public List<Failure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.services());
        hashCode = 31 * hashCode + Objects.hashCode(this.failures());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesResponse)) {
            return false;
        }
        DescribeServicesResponse other = (DescribeServicesResponse)((Object)obj);
        return Objects.equals(this.services(), other.services()) && Objects.equals(this.failures(), other.failures());
    }

    public String toString() {
        return ToString.builder((String)"DescribeServicesResponse").add("Services", this.services()).add("Failures", this.failures()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServicesResponse, T> g) {
        return obj -> g.apply((DescribeServicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<Service> services = DefaultSdkAutoConstructList.getInstance();
        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServicesResponse model) {
            super(model);
            this.services(model.services);
            this.failures(model.failures);
        }

        public final Collection<Service.Builder> getServices() {
            return this.services != null ? (Collection)this.services.stream().map(Service::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServicesCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<Service.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (Service)((Service.Builder)Service.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServicesCopier.copyFromBuilder(services);
        }

        public final Collection<Failure.Builder> getFailures() {
            return this.failures != null ? (Collection)this.failures.stream().map(Failure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (Failure)((Failure.Builder)Failure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public DescribeServicesResponse build() {
            return new DescribeServicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServicesResponse> {
        public Builder services(Collection<Service> var1);

        public Builder services(Service ... var1);

        public Builder services(Consumer<Service.Builder> ... var1);

        public Builder failures(Collection<Failure> var1);

        public Builder failures(Failure ... var1);

        public Builder failures(Consumer<Failure.Builder> ... var1);
    }
}

