/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContainerInstancesResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, ListContainerInstancesResponse> {
    private static final SdkField<List<String>> CONTAINER_INSTANCE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListContainerInstancesResponse.getter(ListContainerInstancesResponse::containerInstanceArns)).setter(ListContainerInstancesResponse.setter(Builder::containerInstanceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerInstanceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListContainerInstancesResponse.getter(ListContainerInstancesResponse::nextToken)).setter(ListContainerInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_INSTANCE_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> containerInstanceArns;
    private final String nextToken;

    private ListContainerInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.containerInstanceArns = builder.containerInstanceArns;
        this.nextToken = builder.nextToken;
    }

    public List<String> containerInstanceArns() {
        return this.containerInstanceArns;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.containerInstanceArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContainerInstancesResponse)) {
            return false;
        }
        ListContainerInstancesResponse other = (ListContainerInstancesResponse)((Object)obj);
        return Objects.equals(this.containerInstanceArns(), other.containerInstanceArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListContainerInstancesResponse").add("ContainerInstanceArns", this.containerInstanceArns()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerInstanceArns": {
                return Optional.ofNullable(clazz.cast(this.containerInstanceArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContainerInstancesResponse, T> g) {
        return obj -> g.apply((ListContainerInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<String> containerInstanceArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContainerInstancesResponse model) {
            super(model);
            this.containerInstanceArns(model.containerInstanceArns);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getContainerInstanceArns() {
            return this.containerInstanceArns;
        }

        @Override
        public final Builder containerInstanceArns(Collection<String> containerInstanceArns) {
            this.containerInstanceArns = StringListCopier.copy(containerInstanceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerInstanceArns(String ... containerInstanceArns) {
            this.containerInstanceArns(Arrays.asList(containerInstanceArns));
            return this;
        }

        public final void setContainerInstanceArns(Collection<String> containerInstanceArns) {
            this.containerInstanceArns = StringListCopier.copy(containerInstanceArns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListContainerInstancesResponse build() {
            return new ListContainerInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContainerInstancesResponse> {
        public Builder containerInstanceArns(Collection<String> var1);

        public Builder containerInstanceArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

