/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsRequest;
import software.amazon.awssdk.services.ecs.model.NetworkBinding;
import software.amazon.awssdk.services.ecs.model.NetworkBindingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubmitContainerStateChangeRequest
extends EcsRequest
implements ToCopyableBuilder<Builder, SubmitContainerStateChangeRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubmitContainerStateChangeRequest.getter(SubmitContainerStateChangeRequest::cluster)).setter(SubmitContainerStateChangeRequest.setter(Builder::cluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()}).build();
    private static final SdkField<String> TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubmitContainerStateChangeRequest.getter(SubmitContainerStateChangeRequest::task)).setter(SubmitContainerStateChangeRequest.setter(Builder::task)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("task").build()}).build();
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubmitContainerStateChangeRequest.getter(SubmitContainerStateChangeRequest::containerName)).setter(SubmitContainerStateChangeRequest.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerName").build()}).build();
    private static final SdkField<String> RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubmitContainerStateChangeRequest.getter(SubmitContainerStateChangeRequest::runtimeId)).setter(SubmitContainerStateChangeRequest.setter(Builder::runtimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubmitContainerStateChangeRequest.getter(SubmitContainerStateChangeRequest::status)).setter(SubmitContainerStateChangeRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> EXIT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(SubmitContainerStateChangeRequest.getter(SubmitContainerStateChangeRequest::exitCode)).setter(SubmitContainerStateChangeRequest.setter(Builder::exitCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitCode").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SubmitContainerStateChangeRequest.getter(SubmitContainerStateChangeRequest::reason)).setter(SubmitContainerStateChangeRequest.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final SdkField<List<NetworkBinding>> NETWORK_BINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SubmitContainerStateChangeRequest.getter(SubmitContainerStateChangeRequest::networkBindings)).setter(SubmitContainerStateChangeRequest.setter(Builder::networkBindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkBindings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkBinding::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_FIELD, TASK_FIELD, CONTAINER_NAME_FIELD, RUNTIME_ID_FIELD, STATUS_FIELD, EXIT_CODE_FIELD, REASON_FIELD, NETWORK_BINDINGS_FIELD));
    private final String cluster;
    private final String task;
    private final String containerName;
    private final String runtimeId;
    private final String status;
    private final Integer exitCode;
    private final String reason;
    private final List<NetworkBinding> networkBindings;

    private SubmitContainerStateChangeRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.task = builder.task;
        this.containerName = builder.containerName;
        this.runtimeId = builder.runtimeId;
        this.status = builder.status;
        this.exitCode = builder.exitCode;
        this.reason = builder.reason;
        this.networkBindings = builder.networkBindings;
    }

    public String cluster() {
        return this.cluster;
    }

    public String task() {
        return this.task;
    }

    public String containerName() {
        return this.containerName;
    }

    public String runtimeId() {
        return this.runtimeId;
    }

    public String status() {
        return this.status;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public String reason() {
        return this.reason;
    }

    public List<NetworkBinding> networkBindings() {
        return this.networkBindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.exitCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBindings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmitContainerStateChangeRequest)) {
            return false;
        }
        SubmitContainerStateChangeRequest other = (SubmitContainerStateChangeRequest)((Object)obj);
        return Objects.equals(this.cluster(), other.cluster()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.runtimeId(), other.runtimeId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.exitCode(), other.exitCode()) && Objects.equals(this.reason(), other.reason()) && Objects.equals(this.networkBindings(), other.networkBindings());
    }

    public String toString() {
        return ToString.builder((String)"SubmitContainerStateChangeRequest").add("Cluster", (Object)this.cluster()).add("Task", (Object)this.task()).add("ContainerName", (Object)this.containerName()).add("RuntimeId", (Object)this.runtimeId()).add("Status", (Object)this.status()).add("ExitCode", (Object)this.exitCode()).add("Reason", (Object)this.reason()).add("NetworkBindings", this.networkBindings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cluster": {
                return Optional.ofNullable(clazz.cast(this.cluster()));
            }
            case "task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "containerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "runtimeId": {
                return Optional.ofNullable(clazz.cast(this.runtimeId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "exitCode": {
                return Optional.ofNullable(clazz.cast(this.exitCode()));
            }
            case "reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "networkBindings": {
                return Optional.ofNullable(clazz.cast(this.networkBindings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubmitContainerStateChangeRequest, T> g) {
        return obj -> g.apply((SubmitContainerStateChangeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsRequest.BuilderImpl
    implements Builder {
        private String cluster;
        private String task;
        private String containerName;
        private String runtimeId;
        private String status;
        private Integer exitCode;
        private String reason;
        private List<NetworkBinding> networkBindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubmitContainerStateChangeRequest model) {
            super(model);
            this.cluster(model.cluster);
            this.task(model.task);
            this.containerName(model.containerName);
            this.runtimeId(model.runtimeId);
            this.status(model.status);
            this.exitCode(model.exitCode);
            this.reason(model.reason);
            this.networkBindings(model.networkBindings);
        }

        public final String getCluster() {
            return this.cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public final String getTask() {
            return this.task;
        }

        @Override
        public final Builder task(String task) {
            this.task = task;
            return this;
        }

        public final void setTask(String task) {
            this.task = task;
        }

        public final String getContainerName() {
            return this.containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public final String getRuntimeId() {
            return this.runtimeId;
        }

        @Override
        public final Builder runtimeId(String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
        }

        public final void setRuntimeId(String runtimeId) {
            this.runtimeId = runtimeId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getExitCode() {
            return this.exitCode;
        }

        @Override
        public final Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public final void setExitCode(Integer exitCode) {
            this.exitCode = exitCode;
        }

        public final String getReason() {
            return this.reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Collection<NetworkBinding.Builder> getNetworkBindings() {
            return this.networkBindings != null ? (Collection)this.networkBindings.stream().map(NetworkBinding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkBindings(Collection<NetworkBinding> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copy(networkBindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(NetworkBinding ... networkBindings) {
            this.networkBindings(Arrays.asList(networkBindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkBindings(Consumer<NetworkBinding.Builder> ... networkBindings) {
            this.networkBindings(Stream.of(networkBindings).map(c -> (NetworkBinding)((NetworkBinding.Builder)NetworkBinding.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkBindings(Collection<NetworkBinding.BuilderImpl> networkBindings) {
            this.networkBindings = NetworkBindingsCopier.copyFromBuilder(networkBindings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubmitContainerStateChangeRequest build() {
            return new SubmitContainerStateChangeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SubmitContainerStateChangeRequest> {
        public Builder cluster(String var1);

        public Builder task(String var1);

        public Builder containerName(String var1);

        public Builder runtimeId(String var1);

        public Builder status(String var1);

        public Builder exitCode(Integer var1);

        public Builder reason(String var1);

        public Builder networkBindings(Collection<NetworkBinding> var1);

        public Builder networkBindings(NetworkBinding ... var1);

        public Builder networkBindings(Consumer<NetworkBinding.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

