/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.ContainerOverride;
import software.amazon.awssdk.services.ecs.model.ContainerOverridesCopier;
import software.amazon.awssdk.services.ecs.model.InferenceAcceleratorOverride;
import software.amazon.awssdk.services.ecs.model.InferenceAcceleratorOverridesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskOverride> {
    private static final SdkField<List<ContainerOverride>> CONTAINER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TaskOverride.getter(TaskOverride::containerOverrides)).setter(TaskOverride.setter(Builder::containerOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InferenceAcceleratorOverride>> INFERENCE_ACCELERATOR_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TaskOverride.getter(TaskOverride::inferenceAcceleratorOverrides)).setter(TaskOverride.setter(Builder::inferenceAcceleratorOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceAcceleratorOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceAcceleratorOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskOverride.getter(TaskOverride::taskRoleArn)).setter(TaskOverride.setter(Builder::taskRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRoleArn").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TaskOverride.getter(TaskOverride::executionRoleArn)).setter(TaskOverride.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_OVERRIDES_FIELD, INFERENCE_ACCELERATOR_OVERRIDES_FIELD, TASK_ROLE_ARN_FIELD, EXECUTION_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ContainerOverride> containerOverrides;
    private final List<InferenceAcceleratorOverride> inferenceAcceleratorOverrides;
    private final String taskRoleArn;
    private final String executionRoleArn;

    private TaskOverride(BuilderImpl builder) {
        this.containerOverrides = builder.containerOverrides;
        this.inferenceAcceleratorOverrides = builder.inferenceAcceleratorOverrides;
        this.taskRoleArn = builder.taskRoleArn;
        this.executionRoleArn = builder.executionRoleArn;
    }

    public List<ContainerOverride> containerOverrides() {
        return this.containerOverrides;
    }

    public List<InferenceAcceleratorOverride> inferenceAcceleratorOverrides() {
        return this.inferenceAcceleratorOverrides;
    }

    public String taskRoleArn() {
        return this.taskRoleArn;
    }

    public String executionRoleArn() {
        return this.executionRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceAcceleratorOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskOverride)) {
            return false;
        }
        TaskOverride other = (TaskOverride)obj;
        return Objects.equals(this.containerOverrides(), other.containerOverrides()) && Objects.equals(this.inferenceAcceleratorOverrides(), other.inferenceAcceleratorOverrides()) && Objects.equals(this.taskRoleArn(), other.taskRoleArn()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn());
    }

    public String toString() {
        return ToString.builder((String)"TaskOverride").add("ContainerOverrides", this.containerOverrides()).add("InferenceAcceleratorOverrides", this.inferenceAcceleratorOverrides()).add("TaskRoleArn", (Object)this.taskRoleArn()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerOverrides": {
                return Optional.ofNullable(clazz.cast(this.containerOverrides()));
            }
            case "inferenceAcceleratorOverrides": {
                return Optional.ofNullable(clazz.cast(this.inferenceAcceleratorOverrides()));
            }
            case "taskRoleArn": {
                return Optional.ofNullable(clazz.cast(this.taskRoleArn()));
            }
            case "executionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TaskOverride, T> g) {
        return obj -> g.apply((TaskOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ContainerOverride> containerOverrides = DefaultSdkAutoConstructList.getInstance();
        private List<InferenceAcceleratorOverride> inferenceAcceleratorOverrides = DefaultSdkAutoConstructList.getInstance();
        private String taskRoleArn;
        private String executionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskOverride model) {
            this.containerOverrides(model.containerOverrides);
            this.inferenceAcceleratorOverrides(model.inferenceAcceleratorOverrides);
            this.taskRoleArn(model.taskRoleArn);
            this.executionRoleArn(model.executionRoleArn);
        }

        public final Collection<ContainerOverride.Builder> getContainerOverrides() {
            return this.containerOverrides != null ? (Collection)this.containerOverrides.stream().map(ContainerOverride::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder containerOverrides(Collection<ContainerOverride> containerOverrides) {
            this.containerOverrides = ContainerOverridesCopier.copy(containerOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerOverrides(ContainerOverride ... containerOverrides) {
            this.containerOverrides(Arrays.asList(containerOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerOverrides(Consumer<ContainerOverride.Builder> ... containerOverrides) {
            this.containerOverrides(Stream.of(containerOverrides).map(c -> (ContainerOverride)((ContainerOverride.Builder)ContainerOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContainerOverrides(Collection<ContainerOverride.BuilderImpl> containerOverrides) {
            this.containerOverrides = ContainerOverridesCopier.copyFromBuilder(containerOverrides);
        }

        public final Collection<InferenceAcceleratorOverride.Builder> getInferenceAcceleratorOverrides() {
            return this.inferenceAcceleratorOverrides != null ? (Collection)this.inferenceAcceleratorOverrides.stream().map(InferenceAcceleratorOverride::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inferenceAcceleratorOverrides(Collection<InferenceAcceleratorOverride> inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides = InferenceAcceleratorOverridesCopier.copy(inferenceAcceleratorOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAcceleratorOverrides(InferenceAcceleratorOverride ... inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides(Arrays.asList(inferenceAcceleratorOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceAcceleratorOverrides(Consumer<InferenceAcceleratorOverride.Builder> ... inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides(Stream.of(inferenceAcceleratorOverrides).map(c -> (InferenceAcceleratorOverride)((InferenceAcceleratorOverride.Builder)InferenceAcceleratorOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInferenceAcceleratorOverrides(Collection<InferenceAcceleratorOverride.BuilderImpl> inferenceAcceleratorOverrides) {
            this.inferenceAcceleratorOverrides = InferenceAcceleratorOverridesCopier.copyFromBuilder(inferenceAcceleratorOverrides);
        }

        public final String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        @Override
        public final Builder taskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        public final void setTaskRoleArn(String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public TaskOverride build() {
            return new TaskOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskOverride> {
        public Builder containerOverrides(Collection<ContainerOverride> var1);

        public Builder containerOverrides(ContainerOverride ... var1);

        public Builder containerOverrides(Consumer<ContainerOverride.Builder> ... var1);

        public Builder inferenceAcceleratorOverrides(Collection<InferenceAcceleratorOverride> var1);

        public Builder inferenceAcceleratorOverrides(InferenceAcceleratorOverride ... var1);

        public Builder inferenceAcceleratorOverrides(Consumer<InferenceAcceleratorOverride.Builder> ... var1);

        public Builder taskRoleArn(String var1);

        public Builder executionRoleArn(String var1);
    }
}

