/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Tmpfs
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Tmpfs> {
    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Tmpfs.getter(Tmpfs::containerPath)).setter(Tmpfs.setter(Builder::containerPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPath").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Tmpfs.getter(Tmpfs::size)).setter(Tmpfs.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("size").build()}).build();
    private static final SdkField<List<String>> MOUNT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Tmpfs.getter(Tmpfs::mountOptions)).setter(Tmpfs.setter(Builder::mountOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PATH_FIELD, SIZE_FIELD, MOUNT_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerPath;
    private final Integer size;
    private final List<String> mountOptions;

    private Tmpfs(BuilderImpl builder) {
        this.containerPath = builder.containerPath;
        this.size = builder.size;
        this.mountOptions = builder.mountOptions;
    }

    public String containerPath() {
        return this.containerPath;
    }

    public Integer size() {
        return this.size;
    }

    public List<String> mountOptions() {
        return this.mountOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.mountOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tmpfs)) {
            return false;
        }
        Tmpfs other = (Tmpfs)obj;
        return Objects.equals(this.containerPath(), other.containerPath()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.mountOptions(), other.mountOptions());
    }

    public String toString() {
        return ToString.builder((String)"Tmpfs").add("ContainerPath", (Object)this.containerPath()).add("Size", (Object)this.size()).add("MountOptions", this.mountOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containerPath": {
                return Optional.ofNullable(clazz.cast(this.containerPath()));
            }
            case "size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "mountOptions": {
                return Optional.ofNullable(clazz.cast(this.mountOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tmpfs, T> g) {
        return obj -> g.apply((Tmpfs)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerPath;
        private Integer size;
        private List<String> mountOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Tmpfs model) {
            this.containerPath(model.containerPath);
            this.size(model.size);
            this.mountOptions(model.mountOptions);
        }

        public final String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final Collection<String> getMountOptions() {
            return this.mountOptions;
        }

        @Override
        public final Builder mountOptions(Collection<String> mountOptions) {
            this.mountOptions = StringListCopier.copy(mountOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountOptions(String ... mountOptions) {
            this.mountOptions(Arrays.asList(mountOptions));
            return this;
        }

        public final void setMountOptions(Collection<String> mountOptions) {
            this.mountOptions = StringListCopier.copy(mountOptions);
        }

        public Tmpfs build() {
            return new Tmpfs(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Tmpfs> {
        public Builder containerPath(String var1);

        public Builder size(Integer var1);

        public Builder mountOptions(Collection<String> var1);

        public Builder mountOptions(String ... var1);
    }
}

