/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMountTargetSecurityGroupsResponse extends EfsResponse implements
        ToCopyableBuilder<DescribeMountTargetSecurityGroupsResponse.Builder, DescribeMountTargetSecurityGroupsResponse> {
    private final List<String> securityGroups;

    private DescribeMountTargetSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroups = builder.securityGroups;
    }

    /**
     * <p>
     * Array of security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of security groups.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetSecurityGroupsResponse)) {
            return false;
        }
        DescribeMountTargetSecurityGroupsResponse other = (DescribeMountTargetSecurityGroupsResponse) obj;
        return Objects.equals(securityGroups(), other.securityGroups());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMountTargetSecurityGroupsResponse").add("SecurityGroups", securityGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroups":
            return Optional.ofNullable(clazz.cast(securityGroups()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EfsResponse.Builder, CopyableBuilder<Builder, DescribeMountTargetSecurityGroupsResponse> {
        /**
         * <p>
         * Array of security groups.
         * </p>
         * 
         * @param securityGroups
         *        Array of security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * Array of security groups.
         * </p>
         * 
         * @param securityGroups
         *        Array of security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetSecurityGroupsResponse model) {
            super(model);
            securityGroups(model.securityGroups);
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public DescribeMountTargetSecurityGroupsResponse build() {
            return new DescribeMountTargetSecurityGroupsResponse(this);
        }
    }
}
