/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned if the file system's life cycle state is not "created".
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncorrectFileSystemLifeCycleStateException extends EfsException implements
        ToCopyableBuilder<IncorrectFileSystemLifeCycleStateException.Builder, IncorrectFileSystemLifeCycleStateException> {
    private final String errorCode;

    private IncorrectFileSystemLifeCycleStateException(BuilderImpl builder) {
        super(builder);
        this.errorCode = builder.errorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ErrorCode property for this object.
     * 
     * @return The value of the ErrorCode property for this object.
     */
    public String errorCode() {
        return errorCode;
    }

    public interface Builder extends CopyableBuilder<Builder, IncorrectFileSystemLifeCycleStateException>, EfsException.Builder {
        /**
         * Sets the value of the ErrorCode property for this object.
         *
         * @param errorCode
         *        The new value for the ErrorCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends EfsException.BuilderImpl implements Builder {
        private String errorCode;

        private BuilderImpl() {
        }

        private BuilderImpl(IncorrectFileSystemLifeCycleStateException model) {
            super(model);
            errorCode(model.errorCode);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @JsonProperty("ErrorCode")
        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public IncorrectFileSystemLifeCycleStateException build() {
            return new IncorrectFileSystemLifeCycleStateException(this);
        }
    }
}
