/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateFileSystemRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateFileSystemRequest.Builder, CreateFileSystemRequest> {
    private final String creationToken;

    private final String performanceMode;

    private CreateFileSystemRequest(BuilderImpl builder) {
        this.creationToken = builder.creationToken;
        this.performanceMode = builder.performanceMode;
    }

    /**
     * <p>
     * String of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
     * </p>
     * 
     * @return String of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
     */
    public String creationToken() {
        return creationToken;
    }

    /**
     * <p>
     * The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code> performance mode
     * for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of
     * aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file
     * operations. This can't be changed after the file system has been created.
     * </p>
     * 
     * @return The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code> performance
     *         mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to
     *         higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher
     *         latencies for most file operations. This can't be changed after the file system has been created.
     * @see PerformanceMode
     */
    public String performanceMode() {
        return performanceMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((creationToken() == null) ? 0 : creationToken().hashCode());
        hashCode = 31 * hashCode + ((performanceMode() == null) ? 0 : performanceMode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemRequest)) {
            return false;
        }
        CreateFileSystemRequest other = (CreateFileSystemRequest) obj;
        if (other.creationToken() == null ^ this.creationToken() == null) {
            return false;
        }
        if (other.creationToken() != null && !other.creationToken().equals(this.creationToken())) {
            return false;
        }
        if (other.performanceMode() == null ^ this.performanceMode() == null) {
            return false;
        }
        if (other.performanceMode() != null && !other.performanceMode().equals(this.performanceMode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (creationToken() != null) {
            sb.append("CreationToken: ").append(creationToken()).append(",");
        }
        if (performanceMode() != null) {
            sb.append("PerformanceMode: ").append(performanceMode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateFileSystemRequest> {
        /**
         * <p>
         * String of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
         * </p>
         * 
         * @param creationToken
         *        String of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationToken(String creationToken);

        /**
         * <p>
         * The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code> performance
         * mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher
         * levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for
         * most file operations. This can't be changed after the file system has been created.
         * </p>
         * 
         * @param performanceMode
         *        The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code>
         *        performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can
         *        scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly
         *        higher latencies for most file operations. This can't be changed after the file system has been
         *        created.
         * @see PerformanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceMode
         */
        Builder performanceMode(String performanceMode);

        /**
         * <p>
         * The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code> performance
         * mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher
         * levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for
         * most file operations. This can't be changed after the file system has been created.
         * </p>
         * 
         * @param performanceMode
         *        The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code>
         *        performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can
         *        scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly
         *        higher latencies for most file operations. This can't be changed after the file system has been
         *        created.
         * @see PerformanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceMode
         */
        Builder performanceMode(PerformanceMode performanceMode);
    }

    private static final class BuilderImpl implements Builder {
        private String creationToken;

        private String performanceMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemRequest model) {
            setCreationToken(model.creationToken);
            setPerformanceMode(model.performanceMode);
        }

        public final String getCreationToken() {
            return creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getPerformanceMode() {
            return performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public final void setPerformanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode.toString());
        }

        @Override
        public CreateFileSystemRequest build() {
            return new CreateFileSystemRequest(this);
        }
    }
}
