/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFileSystemsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeFileSystemsRequest.Builder, DescribeFileSystemsRequest> {
    private final Integer maxItems;

    private final String marker;

    private final String creationToken;

    private final String fileSystemId;

    private DescribeFileSystemsRequest(BuilderImpl builder) {
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
    }

    /**
     * <p>
     * (Optional) Specifies the maximum number of file systems to return in the response (integer). This parameter value
     * must be greater than 0. The number of items that Amazon EFS returns is the minimum of the <code>MaxItems</code>
     * parameter specified in the request and the service's internal maximum number of items per page.
     * </p>
     * 
     * @return (Optional) Specifies the maximum number of file systems to return in the response (integer). This
     *         parameter value must be greater than 0. The number of items that Amazon EFS returns is the minimum of the
     *         <code>MaxItems</code> parameter specified in the request and the service's internal maximum number of
     *         items per page.
     */
    public Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation (String).
     * If present, specifies to continue the list from where the returning call had left off.
     * </p>
     * 
     * @return (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation
     *         (String). If present, specifies to continue the list from where the returning call had left off.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * (Optional) Restricts the list to the file system with this creation token (String). You specify a creation token
     * when you create an Amazon EFS file system.
     * </p>
     * 
     * @return (Optional) Restricts the list to the file system with this creation token (String). You specify a
     *         creation token when you create an Amazon EFS file system.
     */
    public String creationToken() {
        return creationToken;
    }

    /**
     * <p>
     * (Optional) ID of the file system whose description you want to retrieve (String).
     * </p>
     * 
     * @return (Optional) ID of the file system whose description you want to retrieve (String).
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((creationToken() == null) ? 0 : creationToken().hashCode());
        hashCode = 31 * hashCode + ((fileSystemId() == null) ? 0 : fileSystemId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsRequest)) {
            return false;
        }
        DescribeFileSystemsRequest other = (DescribeFileSystemsRequest) obj;
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.creationToken() == null ^ this.creationToken() == null) {
            return false;
        }
        if (other.creationToken() != null && !other.creationToken().equals(this.creationToken())) {
            return false;
        }
        if (other.fileSystemId() == null ^ this.fileSystemId() == null) {
            return false;
        }
        if (other.fileSystemId() != null && !other.fileSystemId().equals(this.fileSystemId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (creationToken() != null) {
            sb.append("CreationToken: ").append(creationToken()).append(",");
        }
        if (fileSystemId() != null) {
            sb.append("FileSystemId: ").append(fileSystemId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeFileSystemsRequest> {
        /**
         * <p>
         * (Optional) Specifies the maximum number of file systems to return in the response (integer). This parameter
         * value must be greater than 0. The number of items that Amazon EFS returns is the minimum of the
         * <code>MaxItems</code> parameter specified in the request and the service's internal maximum number of items
         * per page.
         * </p>
         * 
         * @param maxItems
         *        (Optional) Specifies the maximum number of file systems to return in the response (integer). This
         *        parameter value must be greater than 0. The number of items that Amazon EFS returns is the minimum of
         *        the <code>MaxItems</code> parameter specified in the request and the service's internal maximum number
         *        of items per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation
         * (String). If present, specifies to continue the list from where the returning call had left off.
         * </p>
         * 
         * @param marker
         *        (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation
         *        (String). If present, specifies to continue the list from where the returning call had left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * (Optional) Restricts the list to the file system with this creation token (String). You specify a creation
         * token when you create an Amazon EFS file system.
         * </p>
         * 
         * @param creationToken
         *        (Optional) Restricts the list to the file system with this creation token (String). You specify a
         *        creation token when you create an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationToken(String creationToken);

        /**
         * <p>
         * (Optional) ID of the file system whose description you want to retrieve (String).
         * </p>
         * 
         * @param fileSystemId
         *        (Optional) ID of the file system whose description you want to retrieve (String).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);
    }

    private static final class BuilderImpl implements Builder {
        private Integer maxItems;

        private String marker;

        private String creationToken;

        private String fileSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsRequest model) {
            setMaxItems(model.maxItems);
            setMarker(model.marker);
            setCreationToken(model.creationToken);
            setFileSystemId(model.fileSystemId);
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getCreationToken() {
            return creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public DescribeFileSystemsRequest build() {
            return new DescribeFileSystemsRequest(this);
        }
    }
}
