/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMountTargetSecurityGroupsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeMountTargetSecurityGroupsRequest.Builder, DescribeMountTargetSecurityGroupsRequest> {
    private final String mountTargetId;

    private DescribeMountTargetSecurityGroupsRequest(BuilderImpl builder) {
        this.mountTargetId = builder.mountTargetId;
    }

    /**
     * <p>
     * ID of the mount target whose security groups you want to retrieve.
     * </p>
     * 
     * @return ID of the mount target whose security groups you want to retrieve.
     */
    public String mountTargetId() {
        return mountTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mountTargetId() == null) ? 0 : mountTargetId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetSecurityGroupsRequest)) {
            return false;
        }
        DescribeMountTargetSecurityGroupsRequest other = (DescribeMountTargetSecurityGroupsRequest) obj;
        if (other.mountTargetId() == null ^ this.mountTargetId() == null) {
            return false;
        }
        if (other.mountTargetId() != null && !other.mountTargetId().equals(this.mountTargetId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (mountTargetId() != null) {
            sb.append("MountTargetId: ").append(mountTargetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMountTargetSecurityGroupsRequest> {
        /**
         * <p>
         * ID of the mount target whose security groups you want to retrieve.
         * </p>
         * 
         * @param mountTargetId
         *        ID of the mount target whose security groups you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargetId(String mountTargetId);
    }

    private static final class BuilderImpl implements Builder {
        private String mountTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetSecurityGroupsRequest model) {
            setMountTargetId(model.mountTargetId);
        }

        public final String getMountTargetId() {
            return mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        @Override
        public DescribeMountTargetSecurityGroupsRequest build() {
            return new DescribeMountTargetSecurityGroupsRequest(this);
        }
    }
}
