/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMountTargetsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeMountTargetsRequest.Builder, DescribeMountTargetsRequest> {
    private final Integer maxItems;

    private final String marker;

    private final String fileSystemId;

    private final String mountTargetId;

    private DescribeMountTargetsRequest(BuilderImpl builder) {
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.fileSystemId = builder.fileSystemId;
        this.mountTargetId = builder.mountTargetId;
    }

    /**
     * <p>
     * (Optional) Maximum number of mount targets to return in the response. It must be an integer with a value greater
     * than zero.
     * </p>
     * 
     * @return (Optional) Maximum number of mount targets to return in the response. It must be an integer with a value
     *         greater than zero.
     */
    public Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * (Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code> operation (String).
     * If present, it specifies to continue the list from where the previous returning call left off.
     * </p>
     * 
     * @return (Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code> operation
     *         (String). If present, it specifies to continue the list from where the previous returning call left off.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * (Optional) ID of the file system whose mount targets you want to list (String). It must be included in your
     * request if <code>MountTargetId</code> is not included.
     * </p>
     * 
     * @return (Optional) ID of the file system whose mount targets you want to list (String). It must be included in
     *         your request if <code>MountTargetId</code> is not included.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * (Optional) ID of the mount target that you want to have described (String). It must be included in your request
     * if <code>FileSystemId</code> is not included.
     * </p>
     * 
     * @return (Optional) ID of the mount target that you want to have described (String). It must be included in your
     *         request if <code>FileSystemId</code> is not included.
     */
    public String mountTargetId() {
        return mountTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((maxItems() == null) ? 0 : maxItems().hashCode());
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((fileSystemId() == null) ? 0 : fileSystemId().hashCode());
        hashCode = 31 * hashCode + ((mountTargetId() == null) ? 0 : mountTargetId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsRequest)) {
            return false;
        }
        DescribeMountTargetsRequest other = (DescribeMountTargetsRequest) obj;
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.fileSystemId() == null ^ this.fileSystemId() == null) {
            return false;
        }
        if (other.fileSystemId() != null && !other.fileSystemId().equals(this.fileSystemId())) {
            return false;
        }
        if (other.mountTargetId() == null ^ this.mountTargetId() == null) {
            return false;
        }
        if (other.mountTargetId() != null && !other.mountTargetId().equals(this.mountTargetId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (maxItems() != null) {
            sb.append("MaxItems: ").append(maxItems()).append(",");
        }
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (fileSystemId() != null) {
            sb.append("FileSystemId: ").append(fileSystemId()).append(",");
        }
        if (mountTargetId() != null) {
            sb.append("MountTargetId: ").append(mountTargetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMountTargetsRequest> {
        /**
         * <p>
         * (Optional) Maximum number of mount targets to return in the response. It must be an integer with a value
         * greater than zero.
         * </p>
         * 
         * @param maxItems
         *        (Optional) Maximum number of mount targets to return in the response. It must be an integer with a
         *        value greater than zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * (Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code> operation
         * (String). If present, it specifies to continue the list from where the previous returning call left off.
         * </p>
         * 
         * @param marker
         *        (Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code>
         *        operation (String). If present, it specifies to continue the list from where the previous returning
         *        call left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * (Optional) ID of the file system whose mount targets you want to list (String). It must be included in your
         * request if <code>MountTargetId</code> is not included.
         * </p>
         * 
         * @param fileSystemId
         *        (Optional) ID of the file system whose mount targets you want to list (String). It must be included in
         *        your request if <code>MountTargetId</code> is not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * (Optional) ID of the mount target that you want to have described (String). It must be included in your
         * request if <code>FileSystemId</code> is not included.
         * </p>
         * 
         * @param mountTargetId
         *        (Optional) ID of the mount target that you want to have described (String). It must be included in
         *        your request if <code>FileSystemId</code> is not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargetId(String mountTargetId);
    }

    private static final class BuilderImpl implements Builder {
        private Integer maxItems;

        private String marker;

        private String fileSystemId;

        private String mountTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsRequest model) {
            setMaxItems(model.maxItems);
            setMarker(model.marker);
            setFileSystemId(model.fileSystemId);
            setMountTargetId(model.mountTargetId);
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getMountTargetId() {
            return mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        @Override
        public DescribeMountTargetsRequest build() {
            return new DescribeMountTargetsRequest(this);
        }
    }
}
