/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTagsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeTagsResponse.Builder, DescribeTagsResponse> {
    private final String marker;

    private final List<Tag> tags;

    private final String nextMarker;

    private DescribeTagsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.tags = builder.tags;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * If the request included a <code>Marker</code>, the response returns that value in this field.
     * </p>
     * 
     * @return If the request included a <code>Marker</code>, the response returns that value in this field.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Returns tags associated with the file system as an array of <code>Tag</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns tags associated with the file system as an array of <code>Tag</code> objects.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * If a value is present, there are more tags to return. In a subsequent request, you can provide the value of
     * <code>NextMarker</code> as the value of the <code>Marker</code> parameter in your next request to retrieve the
     * next set of tags.
     * </p>
     * 
     * @return If a value is present, there are more tags to return. In a subsequent request, you can provide the value
     *         of <code>NextMarker</code> as the value of the <code>Marker</code> parameter in your next request to
     *         retrieve the next set of tags.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((nextMarker() == null) ? 0 : nextMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse) obj;
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTagsResponse> {
        /**
         * <p>
         * If the request included a <code>Marker</code>, the response returns that value in this field.
         * </p>
         * 
         * @param marker
         *        If the request included a <code>Marker</code>, the response returns that value in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Returns tags associated with the file system as an array of <code>Tag</code> objects.
         * </p>
         * 
         * @param tags
         *        Returns tags associated with the file system as an array of <code>Tag</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Returns tags associated with the file system as an array of <code>Tag</code> objects.
         * </p>
         * 
         * @param tags
         *        Returns tags associated with the file system as an array of <code>Tag</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * If a value is present, there are more tags to return. In a subsequent request, you can provide the value of
         * <code>NextMarker</code> as the value of the <code>Marker</code> parameter in your next request to retrieve
         * the next set of tags.
         * </p>
         * 
         * @param nextMarker
         *        If a value is present, there are more tags to return. In a subsequent request, you can provide the
         *        value of <code>NextMarker</code> as the value of the <code>Marker</code> parameter in your next
         *        request to retrieve the next set of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    private static final class BuilderImpl implements Builder {
        private String marker;

        private List<Tag> tags;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            setMarker(model.marker);
            setTags(model.tags);
            setNextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }
}
