/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyMountTargetSecurityGroupsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyMountTargetSecurityGroupsRequest.Builder, ModifyMountTargetSecurityGroupsRequest> {
    private final String mountTargetId;

    private final List<String> securityGroups;

    private ModifyMountTargetSecurityGroupsRequest(BuilderImpl builder) {
        this.mountTargetId = builder.mountTargetId;
        this.securityGroups = builder.securityGroups;
    }

    /**
     * <p>
     * ID of the mount target whose security groups you want to modify.
     * </p>
     * 
     * @return ID of the mount target whose security groups you want to modify.
     */
    public String mountTargetId() {
        return mountTargetId;
    }

    /**
     * <p>
     * Array of up to five VPC security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of up to five VPC security group IDs.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((mountTargetId() == null) ? 0 : mountTargetId().hashCode());
        hashCode = 31 * hashCode + ((securityGroups() == null) ? 0 : securityGroups().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyMountTargetSecurityGroupsRequest)) {
            return false;
        }
        ModifyMountTargetSecurityGroupsRequest other = (ModifyMountTargetSecurityGroupsRequest) obj;
        if (other.mountTargetId() == null ^ this.mountTargetId() == null) {
            return false;
        }
        if (other.mountTargetId() != null && !other.mountTargetId().equals(this.mountTargetId())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (mountTargetId() != null) {
            sb.append("MountTargetId: ").append(mountTargetId()).append(",");
        }
        if (securityGroups() != null) {
            sb.append("SecurityGroups: ").append(securityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyMountTargetSecurityGroupsRequest> {
        /**
         * <p>
         * ID of the mount target whose security groups you want to modify.
         * </p>
         * 
         * @param mountTargetId
         *        ID of the mount target whose security groups you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargetId(String mountTargetId);

        /**
         * <p>
         * Array of up to five VPC security group IDs.
         * </p>
         * 
         * @param securityGroups
         *        Array of up to five VPC security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * Array of up to five VPC security group IDs.
         * </p>
         * 
         * @param securityGroups
         *        Array of up to five VPC security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);
    }

    private static final class BuilderImpl implements Builder {
        private String mountTargetId;

        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyMountTargetSecurityGroupsRequest model) {
            setMountTargetId(model.mountTargetId);
            setSecurityGroups(model.securityGroups);
        }

        public final String getMountTargetId() {
            return mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @SafeVarargs
        public final void setSecurityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
        }

        @Override
        public ModifyMountTargetSecurityGroupsRequest build() {
            return new ModifyMountTargetSecurityGroupsRequest(this);
        }
    }
}
