/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.efs.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CreateMountTargetResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateMountTargetResponseUnmarshaller implements Unmarshaller<CreateMountTargetResponse, JsonUnmarshallerContext> {

    public CreateMountTargetResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        CreateMountTargetResponse.Builder createMountTargetResponseBuilder = CreateMountTargetResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return createMountTargetResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("OwnerId", targetDepth)) {
                    context.nextToken();
                    createMountTargetResponseBuilder.ownerId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MountTargetId", targetDepth)) {
                    context.nextToken();
                    createMountTargetResponseBuilder.mountTargetId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("FileSystemId", targetDepth)) {
                    context.nextToken();
                    createMountTargetResponseBuilder.fileSystemId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("SubnetId", targetDepth)) {
                    context.nextToken();
                    createMountTargetResponseBuilder.subnetId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LifeCycleState", targetDepth)) {
                    context.nextToken();
                    createMountTargetResponseBuilder.lifeCycleState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("IpAddress", targetDepth)) {
                    context.nextToken();
                    createMountTargetResponseBuilder.ipAddress(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("NetworkInterfaceId", targetDepth)) {
                    context.nextToken();
                    createMountTargetResponseBuilder
                            .networkInterfaceId(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return createMountTargetResponseBuilder.build();
    }

    private static CreateMountTargetResponseUnmarshaller INSTANCE;

    public static CreateMountTargetResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CreateMountTargetResponseUnmarshaller();
        return INSTANCE;
    }
}
