/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateMountTargetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateMountTargetRequest.Builder, CreateMountTargetRequest> {
    private final String fileSystemId;

    private final String subnetId;

    private final String ipAddress;

    private final List<String> securityGroups;

    private CreateMountTargetRequest(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.subnetId = builder.subnetId;
        this.ipAddress = builder.ipAddress;
        this.securityGroups = builder.securityGroups;
    }

    /**
     * <p>
     * ID of the file system for which to create the mount target.
     * </p>
     * 
     * @return ID of the file system for which to create the mount target.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * ID of the subnet to add the mount target in.
     * </p>
     * 
     * @return ID of the subnet to add the mount target in.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * Valid IPv4 address within the address range of the specified subnet.
     * </p>
     * 
     * @return Valid IPv4 address within the address range of the specified subnet.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be for the same VPC as subnet
     * specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be for the same VPC
     *         as subnet specified.
     */
    public List<String> securityGroups() {
        return securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fileSystemId() == null) ? 0 : fileSystemId().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        hashCode = 31 * hashCode + ((ipAddress() == null) ? 0 : ipAddress().hashCode());
        hashCode = 31 * hashCode + ((securityGroups() == null) ? 0 : securityGroups().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMountTargetRequest)) {
            return false;
        }
        CreateMountTargetRequest other = (CreateMountTargetRequest) obj;
        if (other.fileSystemId() == null ^ this.fileSystemId() == null) {
            return false;
        }
        if (other.fileSystemId() != null && !other.fileSystemId().equals(this.fileSystemId())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.securityGroups() == null ^ this.securityGroups() == null) {
            return false;
        }
        if (other.securityGroups() != null && !other.securityGroups().equals(this.securityGroups())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (fileSystemId() != null) {
            sb.append("FileSystemId: ").append(fileSystemId()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (ipAddress() != null) {
            sb.append("IpAddress: ").append(ipAddress()).append(",");
        }
        if (securityGroups() != null) {
            sb.append("SecurityGroups: ").append(securityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateMountTargetRequest> {
        /**
         * <p>
         * ID of the file system for which to create the mount target.
         * </p>
         * 
         * @param fileSystemId
         *        ID of the file system for which to create the mount target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * ID of the subnet to add the mount target in.
         * </p>
         * 
         * @param subnetId
         *        ID of the subnet to add the mount target in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Valid IPv4 address within the address range of the specified subnet.
         * </p>
         * 
         * @param ipAddress
         *        Valid IPv4 address within the address range of the specified subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be for the same VPC as
         * subnet specified.
         * </p>
         * 
         * @param securityGroups
         *        Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be for the same
         *        VPC as subnet specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(Collection<String> securityGroups);

        /**
         * <p>
         * Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be for the same VPC as
         * subnet specified.
         * </p>
         * 
         * @param securityGroups
         *        Up to five VPC security group IDs, of the form <code>sg-xxxxxxxx</code>. These must be for the same
         *        VPC as subnet specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroups(String... securityGroups);
    }

    private static final class BuilderImpl implements Builder {
        private String fileSystemId;

        private String subnetId;

        private String ipAddress;

        private List<String> securityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMountTargetRequest model) {
            setFileSystemId(model.fileSystemId);
            setSubnetId(model.subnetId);
            setIpAddress(model.ipAddress);
            setSecurityGroups(model.securityGroups);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final Collection<String> getSecurityGroups() {
            return securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String... securityGroups) {
            securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public CreateMountTargetRequest build() {
            return new CreateMountTargetRequest(this);
        }
    }
}
