/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMountTargetsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeMountTargetsResponse.Builder, DescribeMountTargetsResponse> {
    private final String marker;

    private final List<MountTargetDescription> mountTargets;

    private final String nextMarker;

    private DescribeMountTargetsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.mountTargets = builder.mountTargets;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * If the request included the <code>Marker</code>, the response returns that value in this field.
     * </p>
     * 
     * @return If the request included the <code>Marker</code>, the response returns that value in this field.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
     */
    public List<MountTargetDescription> mountTargets() {
        return mountTargets;
    }

    /**
     * <p>
     * If a value is present, there are more mount targets to return. In a subsequent request, you can provide
     * <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
     * </p>
     * 
     * @return If a value is present, there are more mount targets to return. In a subsequent request, you can provide
     *         <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((mountTargets() == null) ? 0 : mountTargets().hashCode());
        hashCode = 31 * hashCode + ((nextMarker() == null) ? 0 : nextMarker().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsResponse)) {
            return false;
        }
        DescribeMountTargetsResponse other = (DescribeMountTargetsResponse) obj;
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.mountTargets() == null ^ this.mountTargets() == null) {
            return false;
        }
        if (other.mountTargets() != null && !other.mountTargets().equals(this.mountTargets())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (mountTargets() != null) {
            sb.append("MountTargets: ").append(mountTargets()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeMountTargetsResponse> {
        /**
         * <p>
         * If the request included the <code>Marker</code>, the response returns that value in this field.
         * </p>
         * 
         * @param marker
         *        If the request included the <code>Marker</code>, the response returns that value in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * </p>
         * 
         * @param mountTargets
         *        Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargets(Collection<MountTargetDescription> mountTargets);

        /**
         * <p>
         * Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * </p>
         * 
         * @param mountTargets
         *        Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargets(MountTargetDescription... mountTargets);

        /**
         * <p>
         * If a value is present, there are more mount targets to return. In a subsequent request, you can provide
         * <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
         * </p>
         * 
         * @param nextMarker
         *        If a value is present, there are more mount targets to return. In a subsequent request, you can
         *        provide <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    private static final class BuilderImpl implements Builder {
        private String marker;

        private List<MountTargetDescription> mountTargets;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsResponse model) {
            setMarker(model.marker);
            setMountTargets(model.mountTargets);
            setNextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<MountTargetDescription> getMountTargets() {
            return mountTargets;
        }

        @Override
        public final Builder mountTargets(Collection<MountTargetDescription> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copy(mountTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountTargets(MountTargetDescription... mountTargets) {
            mountTargets(Arrays.asList(mountTargets));
            return this;
        }

        public final void setMountTargets(Collection<MountTargetDescription> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copy(mountTargets);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeMountTargetsResponse build() {
            return new DescribeMountTargetsResponse(this);
        }
    }
}
