/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned if the file system you are trying to create already exists, with the creation token you provided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FileSystemAlreadyExistsException extends EFSException implements
        ToCopyableBuilder<FileSystemAlreadyExistsException.Builder, FileSystemAlreadyExistsException> {
    private final String errorCode;

    private final String fileSystemId;

    private FileSystemAlreadyExistsException(BuilderImpl builder) {
        super(builder.message);
        this.errorCode = builder.errorCode;
        this.fileSystemId = builder.fileSystemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ErrorCode property for this object.
     * 
     * @return The value of the ErrorCode property for this object.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * Returns the value of the FileSystemId property for this object.
     * 
     * @return The value of the FileSystemId property for this object.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    public interface Builder extends CopyableBuilder<Builder, FileSystemAlreadyExistsException> {
        /**
         * Sets the value of the ErrorCode property for this object.
         *
         * @param errorCode
         *        The new value for the ErrorCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * Sets the value of the FileSystemId property for this object.
         *
         * @param fileSystemId
         *        The new value for the FileSystemId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private String errorCode;

        private String fileSystemId;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemAlreadyExistsException model) {
            setErrorCode(model.errorCode);
            setFileSystemId(model.fileSystemId);
            this.message = model.getMessage();
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @JsonProperty("ErrorCode")
        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        @JsonProperty("FileSystemId")
        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public FileSystemAlreadyExistsException build() {
            return new FileSystemAlreadyExistsException(this);
        }
    }
}
