/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteTagsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteTagsRequest.Builder, DeleteTagsRequest> {
    private final String fileSystemId;

    private final List<String> tagKeys;

    private DeleteTagsRequest(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.tagKeys = builder.tagKeys;
    }

    /**
     * <p>
     * ID of the file system whose tags you want to delete (String).
     * </p>
     * 
     * @return ID of the file system whose tags you want to delete (String).
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * List of tag keys to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return List of tag keys to delete.
     */
    public List<String> tagKeys() {
        return tagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fileSystemId() == null) ? 0 : fileSystemId().hashCode());
        hashCode = 31 * hashCode + ((tagKeys() == null) ? 0 : tagKeys().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsRequest)) {
            return false;
        }
        DeleteTagsRequest other = (DeleteTagsRequest) obj;
        if (other.fileSystemId() == null ^ this.fileSystemId() == null) {
            return false;
        }
        if (other.fileSystemId() != null && !other.fileSystemId().equals(this.fileSystemId())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        if (other.tagKeys() != null && !other.tagKeys().equals(this.tagKeys())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fileSystemId() != null) {
            sb.append("FileSystemId: ").append(fileSystemId()).append(",");
        }
        if (tagKeys() != null) {
            sb.append("TagKeys: ").append(tagKeys()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.of(clazz.cast(fileSystemId()));
        case "TagKeys":
            return Optional.of(clazz.cast(tagKeys()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteTagsRequest> {
        /**
         * <p>
         * ID of the file system whose tags you want to delete (String).
         * </p>
         * 
         * @param fileSystemId
         *        ID of the file system whose tags you want to delete (String).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * List of tag keys to delete.
         * </p>
         * 
         * @param tagKeys
         *        List of tag keys to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(Collection<String> tagKeys);

        /**
         * <p>
         * List of tag keys to delete.
         * </p>
         * 
         * @param tagKeys
         *        List of tag keys to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(String... tagKeys);
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemId;

        private List<String> tagKeys;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsRequest model) {
            fileSystemId(model.fileSystemId);
            tagKeys(model.tagKeys);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final Collection<String> getTagKeys() {
            return tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeysCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String... tagKeys) {
            tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeysCopier.copy(tagKeys);
        }

        @Override
        public DeleteTagsRequest build() {
            return new DeleteTagsRequest(this);
        }
    }
}
