/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeFileSystemsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeFileSystemsRequest> {
    private final Integer maxItems;
    private final String marker;
    private final String creationToken;
    private final String fileSystemId;

    private DescribeFileSystemsRequest(BuilderImpl builder) {
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public String marker() {
        return this.marker;
    }

    public String creationToken() {
        return this.creationToken;
    }

    public String fileSystemId() {
        return this.fileSystemId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.creationToken() == null ? 0 : this.creationToken().hashCode());
        hashCode = 31 * hashCode + (this.fileSystemId() == null ? 0 : this.fileSystemId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsRequest)) {
            return false;
        }
        DescribeFileSystemsRequest other = (DescribeFileSystemsRequest)((Object)obj);
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        if (other.maxItems() != null && !other.maxItems().equals(this.maxItems())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.creationToken() == null ^ this.creationToken() == null) {
            return false;
        }
        if (other.creationToken() != null && !other.creationToken().equals(this.creationToken())) {
            return false;
        }
        if (other.fileSystemId() == null ^ this.fileSystemId() == null) {
            return false;
        }
        return other.fileSystemId() == null || other.fileSystemId().equals(this.fileSystemId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.creationToken() != null) {
            sb.append("CreationToken: ").append(this.creationToken()).append(",");
        }
        if (this.fileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.fileSystemId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "CreationToken": {
                return Optional.of(clazz.cast(this.creationToken()));
            }
            case "FileSystemId": {
                return Optional.of(clazz.cast(this.fileSystemId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxItems;
        private String marker;
        private String creationToken;
        private String fileSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsRequest model) {
            this.maxItems(model.maxItems);
            this.marker(model.marker);
            this.creationToken(model.creationToken);
            this.fileSystemId(model.fileSystemId);
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getCreationToken() {
            return this.creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public DescribeFileSystemsRequest build() {
            return new DescribeFileSystemsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeFileSystemsRequest> {
        public Builder maxItems(Integer var1);

        public Builder marker(String var1);

        public Builder creationToken(String var1);

        public Builder fileSystemId(String var1);
    }
}

