/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.efs.model.Tag;
import software.amazon.awssdk.services.efs.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTagsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private final String marker;
    private final List<Tag> tags;
    private final String nextMarker;

    private DescribeTagsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.tags = builder.tags;
        this.nextMarker = builder.nextMarker;
    }

    public String marker() {
        return this.marker;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        return other.nextMarker() == null || other.nextMarker().equals(this.nextMarker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<Tag> tags;
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            this.marker(model.marker);
            this.tags(model.tags);
            this.nextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder marker(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder nextMarker(String var1);
    }
}

