/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateFileSystemRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateFileSystemRequest.Builder, CreateFileSystemRequest> {
    private final String creationToken;

    private final String performanceMode;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private CreateFileSystemRequest(BuilderImpl builder) {
        this.creationToken = builder.creationToken;
        this.performanceMode = builder.performanceMode;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
    }

    /**
     * <p>
     * String of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
     * </p>
     * 
     * @return String of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
     */
    public String creationToken() {
        return creationToken;
    }

    /**
     * <p>
     * The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code> performance mode
     * for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of
     * aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file
     * operations. This can't be changed after the file system has been created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #performanceMode}
     * will return {@link PerformanceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #performanceModeString}.
     * </p>
     * 
     * @return The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code> performance
     *         mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to
     *         higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher
     *         latencies for most file operations. This can't be changed after the file system has been created.
     * @see PerformanceMode
     */
    public PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(performanceMode);
    }

    /**
     * <p>
     * The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code> performance mode
     * for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of
     * aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file
     * operations. This can't be changed after the file system has been created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #performanceMode}
     * will return {@link PerformanceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #performanceModeString}.
     * </p>
     * 
     * @return The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code> performance
     *         mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to
     *         higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher
     *         latencies for most file operations. This can't be changed after the file system has been created.
     * @see PerformanceMode
     */
    public String performanceModeString() {
        return performanceMode;
    }

    /**
     * <p>
     * A boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you have
     * the option of specifying a <a>CreateFileSystemRequest$KmsKeyId</a> for an existing AWS Key Management Service
     * (AWS KMS) customer master key (CMK). If you don't specify a CMK, then the default CMK for Amazon EFS,
     * <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
     * </p>
     * 
     * @return A boolean value that, if true, creates an encrypted file system. When creating an encrypted file system,
     *         you have the option of specifying a <a>CreateFileSystemRequest$KmsKeyId</a> for an existing AWS Key
     *         Management Service (AWS KMS) customer master key (CMK). If you don't specify a CMK, then the default CMK
     *         for Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The id of the AWS KMS CMK that will be used to protect the encrypted file system. This parameter is only required
     * if you want to use a non-default CMK. If this parameter is not specified, the default CMK for Amazon EFS is used.
     * This id can be in one of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID - A unique identifier of the key. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN - An Amazon Resource Name for the key. For example,
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias - A previously created display name for a key. For example, <code>alias/projectKey1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias ARN - An Amazon Resource Name for a key alias. For example,
     * <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that if the KmsKeyId is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set to
     * true.
     * </p>
     * 
     * @return The id of the AWS KMS CMK that will be used to protect the encrypted file system. This parameter is only
     *         required if you want to use a non-default CMK. If this parameter is not specified, the default CMK for
     *         Amazon EFS is used. This id can be in one of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID - A unique identifier of the key. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN - An Amazon Resource Name for the key. For example,
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias - A previously created display name for a key. For example, <code>alias/projectKey1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias ARN - An Amazon Resource Name for a key alias. For example,
     *         <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Note that if the KmsKeyId is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be
     *         set to true.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(performanceModeString());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemRequest)) {
            return false;
        }
        CreateFileSystemRequest other = (CreateFileSystemRequest) obj;
        return Objects.equals(creationToken(), other.creationToken())
                && Objects.equals(performanceModeString(), other.performanceModeString())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (creationToken() != null) {
            sb.append("CreationToken: ").append(creationToken()).append(",");
        }
        if (performanceModeString() != null) {
            sb.append("PerformanceMode: ").append(performanceModeString()).append(",");
        }
        if (encrypted() != null) {
            sb.append("Encrypted: ").append(encrypted()).append(",");
        }
        if (kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(kmsKeyId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationToken":
            return Optional.of(clazz.cast(creationToken()));
        case "PerformanceMode":
            return Optional.of(clazz.cast(performanceModeString()));
        case "Encrypted":
            return Optional.of(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.of(clazz.cast(kmsKeyId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateFileSystemRequest> {
        /**
         * <p>
         * String of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
         * </p>
         * 
         * @param creationToken
         *        String of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationToken(String creationToken);

        /**
         * <p>
         * The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code> performance
         * mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher
         * levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for
         * most file operations. This can't be changed after the file system has been created.
         * </p>
         * 
         * @param performanceMode
         *        The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code>
         *        performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can
         *        scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly
         *        higher latencies for most file operations. This can't be changed after the file system has been
         *        created.
         * @see PerformanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceMode
         */
        Builder performanceMode(String performanceMode);

        /**
         * <p>
         * The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code> performance
         * mode for most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher
         * levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for
         * most file operations. This can't be changed after the file system has been created.
         * </p>
         * 
         * @param performanceMode
         *        The <code>PerformanceMode</code> of the file system. We recommend <code>generalPurpose</code>
         *        performance mode for most file systems. File systems using the <code>maxIO</code> performance mode can
         *        scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly
         *        higher latencies for most file operations. This can't be changed after the file system has been
         *        created.
         * @see PerformanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceMode
         */
        Builder performanceMode(PerformanceMode performanceMode);

        /**
         * <p>
         * A boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you
         * have the option of specifying a <a>CreateFileSystemRequest$KmsKeyId</a> for an existing AWS Key Management
         * Service (AWS KMS) customer master key (CMK). If you don't specify a CMK, then the default CMK for Amazon EFS,
         * <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
         * </p>
         * 
         * @param encrypted
         *        A boolean value that, if true, creates an encrypted file system. When creating an encrypted file
         *        system, you have the option of specifying a <a>CreateFileSystemRequest$KmsKeyId</a> for an existing
         *        AWS Key Management Service (AWS KMS) customer master key (CMK). If you don't specify a CMK, then the
         *        default CMK for Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file
         *        system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The id of the AWS KMS CMK that will be used to protect the encrypted file system. This parameter is only
         * required if you want to use a non-default CMK. If this parameter is not specified, the default CMK for Amazon
         * EFS is used. This id can be in one of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID - A unique identifier of the key. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN - An Amazon Resource Name for the key. For example,
         * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias - A previously created display name for a key. For example, <code>alias/projectKey1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias ARN - An Amazon Resource Name for a key alias. For example,
         * <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Note that if the KmsKeyId is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set to
         * true.
         * </p>
         * 
         * @param kmsKeyId
         *        The id of the AWS KMS CMK that will be used to protect the encrypted file system. This parameter is
         *        only required if you want to use a non-default CMK. If this parameter is not specified, the default
         *        CMK for Amazon EFS is used. This id can be in one of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID - A unique identifier of the key. For example,
         *        <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN - An Amazon Resource Name for the key. For example,
         *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias - A previously created display name for a key. For example, <code>alias/projectKey1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias ARN - An Amazon Resource Name for a key alias. For example,
         *        <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Note that if the KmsKeyId is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be
         *        set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);
    }

    static final class BuilderImpl implements Builder {
        private String creationToken;

        private String performanceMode;

        private Boolean encrypted;

        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemRequest model) {
            creationToken(model.creationToken);
            performanceMode(model.performanceMode);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
        }

        public final String getCreationToken() {
            return creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getPerformanceMode() {
            return performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public CreateFileSystemRequest build() {
            return new CreateFileSystemRequest(this);
        }
    }
}
