/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateTagsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateTagsRequest.Builder, CreateTagsRequest> {
    private final String fileSystemId;

    private final List<Tag> tags;

    private CreateTagsRequest(BuilderImpl builder) {
        this.fileSystemId = builder.fileSystemId;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * ID of the file system whose tags you want to modify (String). This operation modifies the tags only, not the file
     * system.
     * </p>
     * 
     * @return ID of the file system whose tags you want to modify (String). This operation modifies the tags only, not
     *         the file system.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * Array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTagsRequest)) {
            return false;
        }
        CreateTagsRequest other = (CreateTagsRequest) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fileSystemId() != null) {
            sb.append("FileSystemId: ").append(fileSystemId()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.of(clazz.cast(fileSystemId()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateTagsRequest> {
        /**
         * <p>
         * ID of the file system whose tags you want to modify (String). This operation modifies the tags only, not the
         * file system.
         * </p>
         * 
         * @param fileSystemId
         *        ID of the file system whose tags you want to modify (String). This operation modifies the tags only,
         *        not the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * Array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair.
         * </p>
         * 
         * @param tags
         *        Array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair.
         * </p>
         * 
         * @param tags
         *        Array of <code>Tag</code> objects to add. Each <code>Tag</code> object is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemId;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTagsRequest model) {
            fileSystemId(model.fileSystemId);
            tags(model.tags);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public CreateTagsRequest build() {
            return new CreateTagsRequest(this);
        }
    }
}
