/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFileSystemsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeFileSystemsResponse.Builder, DescribeFileSystemsResponse> {
    private final String marker;

    private final List<FileSystemDescription> fileSystems;

    private final String nextMarker;

    private DescribeFileSystemsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.fileSystems = builder.fileSystems;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * Present if provided by caller in the request (String).
     * </p>
     * 
     * @return Present if provided by caller in the request (String).
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Array of file system descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Array of file system descriptions.
     */
    public List<FileSystemDescription> fileSystems() {
        return fileSystems;
    }

    /**
     * <p>
     * Present if there are more file systems than returned in the response (String). You can use the
     * <code>NextMarker</code> in the subsequent request to fetch the descriptions.
     * </p>
     * 
     * @return Present if there are more file systems than returned in the response (String). You can use the
     *         <code>NextMarker</code> in the subsequent request to fetch the descriptions.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystems());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsResponse)) {
            return false;
        }
        DescribeFileSystemsResponse other = (DescribeFileSystemsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(fileSystems(), other.fileSystems())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (fileSystems() != null) {
            sb.append("FileSystems: ").append(fileSystems()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "FileSystems":
            return Optional.of(clazz.cast(fileSystems()));
        case "NextMarker":
            return Optional.of(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeFileSystemsResponse> {
        /**
         * <p>
         * Present if provided by caller in the request (String).
         * </p>
         * 
         * @param marker
         *        Present if provided by caller in the request (String).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Array of file system descriptions.
         * </p>
         * 
         * @param fileSystems
         *        Array of file system descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystems(Collection<FileSystemDescription> fileSystems);

        /**
         * <p>
         * Array of file system descriptions.
         * </p>
         * 
         * @param fileSystems
         *        Array of file system descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystems(FileSystemDescription... fileSystems);

        /**
         * <p>
         * Present if there are more file systems than returned in the response (String). You can use the
         * <code>NextMarker</code> in the subsequent request to fetch the descriptions.
         * </p>
         * 
         * @param nextMarker
         *        Present if there are more file systems than returned in the response (String). You can use the
         *        <code>NextMarker</code> in the subsequent request to fetch the descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl implements Builder {
        private String marker;

        private List<FileSystemDescription> fileSystems;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsResponse model) {
            marker(model.marker);
            fileSystems(model.fileSystems);
            nextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<FileSystemDescription.Builder> getFileSystems() {
            return fileSystems != null ? fileSystems.stream().map(FileSystemDescription::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder fileSystems(Collection<FileSystemDescription> fileSystems) {
            this.fileSystems = FileSystemDescriptionsCopier.copy(fileSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystems(FileSystemDescription... fileSystems) {
            fileSystems(Arrays.asList(fileSystems));
            return this;
        }

        public final void setFileSystems(Collection<FileSystemDescription.BuilderImpl> fileSystems) {
            this.fileSystems = FileSystemDescriptionsCopier.copyFromBuilder(fileSystems);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeFileSystemsResponse build() {
            return new DescribeFileSystemsResponse(this);
        }
    }
}
