/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.efs.transform.MountTargetDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a description of a mount target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MountTargetDescription implements StructuredPojo,
        ToCopyableBuilder<MountTargetDescription.Builder, MountTargetDescription> {
    private final String ownerId;

    private final String mountTargetId;

    private final String fileSystemId;

    private final String subnetId;

    private final String lifeCycleState;

    private final String ipAddress;

    private final String networkInterfaceId;

    private MountTargetDescription(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.mountTargetId = builder.mountTargetId;
        this.fileSystemId = builder.fileSystemId;
        this.subnetId = builder.subnetId;
        this.lifeCycleState = builder.lifeCycleState;
        this.ipAddress = builder.ipAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    /**
     * <p>
     * AWS account ID that owns the resource.
     * </p>
     * 
     * @return AWS account ID that owns the resource.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * System-assigned mount target ID.
     * </p>
     * 
     * @return System-assigned mount target ID.
     */
    public String mountTargetId() {
        return mountTargetId;
    }

    /**
     * <p>
     * ID of the file system for which the mount target is intended.
     * </p>
     * 
     * @return ID of the file system for which the mount target is intended.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * ID of the mount target's subnet.
     * </p>
     * 
     * @return ID of the mount target's subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * Lifecycle state of the mount target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateString}.
     * </p>
     * 
     * @return Lifecycle state of the mount target.
     * @see LifeCycleState
     */
    public LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(lifeCycleState);
    }

    /**
     * <p>
     * Lifecycle state of the mount target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateString}.
     * </p>
     * 
     * @return Lifecycle state of the mount target.
     * @see LifeCycleState
     */
    public String lifeCycleStateString() {
        return lifeCycleState;
    }

    /**
     * <p>
     * Address at which the file system may be mounted via the mount target.
     * </p>
     * 
     * @return Address at which the file system may be mounted via the mount target.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * ID of the network interface that Amazon EFS created when it created the mount target.
     * </p>
     * 
     * @return ID of the network interface that Amazon EFS created when it created the mount target.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(mountTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleStateString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountTargetDescription)) {
            return false;
        }
        MountTargetDescription other = (MountTargetDescription) obj;
        return Objects.equals(ownerId(), other.ownerId()) && Objects.equals(mountTargetId(), other.mountTargetId())
                && Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(lifeCycleStateString(), other.lifeCycleStateString())
                && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (mountTargetId() != null) {
            sb.append("MountTargetId: ").append(mountTargetId()).append(",");
        }
        if (fileSystemId() != null) {
            sb.append("FileSystemId: ").append(fileSystemId()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (lifeCycleStateString() != null) {
            sb.append("LifeCycleState: ").append(lifeCycleStateString()).append(",");
        }
        if (ipAddress() != null) {
            sb.append("IpAddress: ").append(ipAddress()).append(",");
        }
        if (networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(networkInterfaceId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.of(clazz.cast(ownerId()));
        case "MountTargetId":
            return Optional.of(clazz.cast(mountTargetId()));
        case "FileSystemId":
            return Optional.of(clazz.cast(fileSystemId()));
        case "SubnetId":
            return Optional.of(clazz.cast(subnetId()));
        case "LifeCycleState":
            return Optional.of(clazz.cast(lifeCycleStateString()));
        case "IpAddress":
            return Optional.of(clazz.cast(ipAddress()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MountTargetDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MountTargetDescription> {
        /**
         * <p>
         * AWS account ID that owns the resource.
         * </p>
         * 
         * @param ownerId
         *        AWS account ID that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * System-assigned mount target ID.
         * </p>
         * 
         * @param mountTargetId
         *        System-assigned mount target ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargetId(String mountTargetId);

        /**
         * <p>
         * ID of the file system for which the mount target is intended.
         * </p>
         * 
         * @param fileSystemId
         *        ID of the file system for which the mount target is intended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * ID of the mount target's subnet.
         * </p>
         * 
         * @param subnetId
         *        ID of the mount target's subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Lifecycle state of the mount target.
         * </p>
         * 
         * @param lifeCycleState
         *        Lifecycle state of the mount target.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(String lifeCycleState);

        /**
         * <p>
         * Lifecycle state of the mount target.
         * </p>
         * 
         * @param lifeCycleState
         *        Lifecycle state of the mount target.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(LifeCycleState lifeCycleState);

        /**
         * <p>
         * Address at which the file system may be mounted via the mount target.
         * </p>
         * 
         * @param ipAddress
         *        Address at which the file system may be mounted via the mount target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * ID of the network interface that Amazon EFS created when it created the mount target.
         * </p>
         * 
         * @param networkInterfaceId
         *        ID of the network interface that Amazon EFS created when it created the mount target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);
    }

    static final class BuilderImpl implements Builder {
        private String ownerId;

        private String mountTargetId;

        private String fileSystemId;

        private String subnetId;

        private String lifeCycleState;

        private String ipAddress;

        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(MountTargetDescription model) {
            ownerId(model.ownerId);
            mountTargetId(model.mountTargetId);
            fileSystemId(model.fileSystemId);
            subnetId(model.subnetId);
            lifeCycleState(model.lifeCycleState);
            ipAddress(model.ipAddress);
            networkInterfaceId(model.networkInterfaceId);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getMountTargetId() {
            return mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getLifeCycleState() {
            return lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState.toString());
            return this;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public MountTargetDescription build() {
            return new MountTargetDescription(this);
        }
    }
}
