/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.efs.transform.FileSystemSizeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FileSystemSize
implements StructuredPojo,
ToCopyableBuilder<Builder, FileSystemSize> {
    private final Long value;
    private final Instant timestamp;

    private FileSystemSize(BuilderImpl builder) {
        this.value = builder.value;
        this.timestamp = builder.timestamp;
    }

    public Long value() {
        return this.value;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemSize)) {
            return false;
        }
        FileSystemSize other = (FileSystemSize)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileSystemSizeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long value;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemSize model) {
            this.value(model.value);
            this.timestamp(model.timestamp);
        }

        public final Long getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public FileSystemSize build() {
            return new FileSystemSize(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FileSystemSize> {
        public Builder value(Long var1);

        public Builder timestamp(Instant var1);
    }
}

