/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteMountTargetRequest extends EFSRequest implements
        ToCopyableBuilder<DeleteMountTargetRequest.Builder, DeleteMountTargetRequest> {
    private final String mountTargetId;

    private DeleteMountTargetRequest(BuilderImpl builder) {
        super(builder);
        this.mountTargetId = builder.mountTargetId;
    }

    /**
     * <p>
     * ID of the mount target to delete (String).
     * </p>
     * 
     * @return ID of the mount target to delete (String).
     */
    public String mountTargetId() {
        return mountTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mountTargetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMountTargetRequest)) {
            return false;
        }
        DeleteMountTargetRequest other = (DeleteMountTargetRequest) obj;
        return Objects.equals(mountTargetId(), other.mountTargetId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteMountTargetRequest").add("MountTargetId", mountTargetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MountTargetId":
            return Optional.of(clazz.cast(mountTargetId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EFSRequest.Builder, CopyableBuilder<Builder, DeleteMountTargetRequest> {
        /**
         * <p>
         * ID of the mount target to delete (String).
         * </p>
         * 
         * @param mountTargetId
         *        ID of the mount target to delete (String).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargetId(String mountTargetId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EFSRequest.BuilderImpl implements Builder {
        private String mountTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMountTargetRequest model) {
            mountTargetId(model.mountTargetId);
        }

        public final String getMountTargetId() {
            return mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteMountTargetRequest build() {
            return new DeleteMountTargetRequest(this);
        }
    }
}
