/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeMountTargetsResponse extends EFSResponse implements
        ToCopyableBuilder<DescribeMountTargetsResponse.Builder, DescribeMountTargetsResponse> {
    private final String marker;

    private final List<MountTargetDescription> mountTargets;

    private final String nextMarker;

    private DescribeMountTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.mountTargets = builder.mountTargets;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * If the request included the <code>Marker</code>, the response returns that value in this field.
     * </p>
     * 
     * @return If the request included the <code>Marker</code>, the response returns that value in this field.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
     */
    public List<MountTargetDescription> mountTargets() {
        return mountTargets;
    }

    /**
     * <p>
     * If a value is present, there are more mount targets to return. In a subsequent request, you can provide
     * <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
     * </p>
     * 
     * @return If a value is present, there are more mount targets to return. In a subsequent request, you can provide
     *         <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(mountTargets());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsResponse)) {
            return false;
        }
        DescribeMountTargetsResponse other = (DescribeMountTargetsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(mountTargets(), other.mountTargets())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeMountTargetsResponse").add("Marker", marker()).add("MountTargets", mountTargets())
                .add("NextMarker", nextMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "MountTargets":
            return Optional.of(clazz.cast(mountTargets()));
        case "NextMarker":
            return Optional.of(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EFSResponse.Builder, CopyableBuilder<Builder, DescribeMountTargetsResponse> {
        /**
         * <p>
         * If the request included the <code>Marker</code>, the response returns that value in this field.
         * </p>
         * 
         * @param marker
         *        If the request included the <code>Marker</code>, the response returns that value in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * </p>
         * 
         * @param mountTargets
         *        Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargets(Collection<MountTargetDescription> mountTargets);

        /**
         * <p>
         * Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * </p>
         * 
         * @param mountTargets
         *        Returns the file system's mount targets as an array of <code>MountTargetDescription</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargets(MountTargetDescription... mountTargets);

        /**
         * <p>
         * If a value is present, there are more mount targets to return. In a subsequent request, you can provide
         * <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
         * </p>
         * 
         * @param nextMarker
         *        If a value is present, there are more mount targets to return. In a subsequent request, you can
         *        provide <code>Marker</code> in your request with this value to retrieve the next set of mount targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends EFSResponse.BuilderImpl implements Builder {
        private String marker;

        private List<MountTargetDescription> mountTargets;

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsResponse model) {
            marker(model.marker);
            mountTargets(model.mountTargets);
            nextMarker(model.nextMarker);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<MountTargetDescription.Builder> getMountTargets() {
            return mountTargets != null ? mountTargets.stream().map(MountTargetDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder mountTargets(Collection<MountTargetDescription> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copy(mountTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountTargets(MountTargetDescription... mountTargets) {
            mountTargets(Arrays.asList(mountTargets));
            return this;
        }

        public final void setMountTargets(Collection<MountTargetDescription.BuilderImpl> mountTargets) {
            this.mountTargets = MountTargetDescriptionsCopier.copyFromBuilder(mountTargets);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public DescribeMountTargetsResponse build() {
            return new DescribeMountTargetsResponse(this);
        }
    }
}
