/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned if <code>IpAddress</code> was not specified in the request and there are no free IP addresses in the subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NoFreeAddressesInSubnetException extends EFSException implements
        ToCopyableBuilder<NoFreeAddressesInSubnetException.Builder, NoFreeAddressesInSubnetException> {
    private final String errorCode;

    private NoFreeAddressesInSubnetException(BuilderImpl builder) {
        super(builder.message);
        this.errorCode = builder.errorCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ErrorCode property for this object.
     * 
     * @return The value of the ErrorCode property for this object.
     */
    public String errorCode() {
        return errorCode;
    }

    public interface Builder extends CopyableBuilder<Builder, NoFreeAddressesInSubnetException> {
        /**
         * Sets the value of the ErrorCode property for this object.
         *
         * @param errorCode
         *        The new value for the ErrorCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(NoFreeAddressesInSubnetException model) {
            errorCode(model.errorCode);
            this.message = model.getMessage();
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @JsonProperty("ErrorCode")
        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return message;
        }

        public String message() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public NoFreeAddressesInSubnetException build() {
            return new NoFreeAddressesInSubnetException(this);
        }
    }
}
