/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;

import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.efs.model.*;
import software.amazon.awssdk.services.efs.transform.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * DescribeMountTargetsRequest Marshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class DescribeMountTargetsRequestMarshaller implements
        Marshaller<Request<DescribeMountTargetsRequest>, DescribeMountTargetsRequest> {

    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().protocol(Protocol.REST_JSON)
            .requestUri("/2015-02-01/mount-targets").httpMethodName(HttpMethodName.GET).hasExplicitPayloadMember(false)
            .hasPayloadMembers(false).build();

    private final software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory protocolFactory;

    public DescribeMountTargetsRequestMarshaller(software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeMountTargetsRequest> marshall(DescribeMountTargetsRequest describeMountTargetsRequest) {

        if (describeMountTargetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            final ProtocolRequestMarshaller<DescribeMountTargetsRequest> protocolMarshaller = protocolFactory
                    .createProtocolMarshaller(SDK_OPERATION_BINDING, describeMountTargetsRequest);

            protocolMarshaller.startMarshalling();
            DescribeMountTargetsRequestModelMarshaller.getInstance().marshall(describeMountTargetsRequest, protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
