/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteFileSystemRequest extends EFSRequest implements
        ToCopyableBuilder<DeleteFileSystemRequest.Builder, DeleteFileSystemRequest> {
    private final String fileSystemId;

    private DeleteFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.fileSystemId = builder.fileSystemId;
    }

    /**
     * <p>
     * ID of the file system you want to delete.
     * </p>
     * 
     * @return ID of the file system you want to delete.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemRequest)) {
            return false;
        }
        DeleteFileSystemRequest other = (DeleteFileSystemRequest) obj;
        return Objects.equals(fileSystemId(), other.fileSystemId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteFileSystemRequest").add("FileSystemId", fileSystemId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileSystemId":
            return Optional.of(clazz.cast(fileSystemId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EFSRequest.Builder, CopyableBuilder<Builder, DeleteFileSystemRequest> {
        /**
         * <p>
         * ID of the file system you want to delete.
         * </p>
         * 
         * @param fileSystemId
         *        ID of the file system you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EFSRequest.BuilderImpl implements Builder {
        private String fileSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemRequest model) {
            fileSystemId(model.fileSystemId);
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteFileSystemRequest build() {
            return new DeleteFileSystemRequest(this);
        }
    }
}
