/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFileSystemsRequest extends EFSRequest implements
        ToCopyableBuilder<DescribeFileSystemsRequest.Builder, DescribeFileSystemsRequest> {
    private final Integer maxItems;

    private final String marker;

    private final String creationToken;

    private final String fileSystemId;

    private DescribeFileSystemsRequest(BuilderImpl builder) {
        super(builder);
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
    }

    /**
     * <p>
     * (Optional) Specifies the maximum number of file systems to return in the response (integer). This parameter value
     * must be greater than 0. The number of items that Amazon EFS returns is the minimum of the <code>MaxItems</code>
     * parameter specified in the request and the service's internal maximum number of items per page.
     * </p>
     * 
     * @return (Optional) Specifies the maximum number of file systems to return in the response (integer). This
     *         parameter value must be greater than 0. The number of items that Amazon EFS returns is the minimum of the
     *         <code>MaxItems</code> parameter specified in the request and the service's internal maximum number of
     *         items per page.
     */
    public Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation (String).
     * If present, specifies to continue the list from where the returning call had left off.
     * </p>
     * 
     * @return (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation
     *         (String). If present, specifies to continue the list from where the returning call had left off.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * (Optional) Restricts the list to the file system with this creation token (String). You specify a creation token
     * when you create an Amazon EFS file system.
     * </p>
     * 
     * @return (Optional) Restricts the list to the file system with this creation token (String). You specify a
     *         creation token when you create an Amazon EFS file system.
     */
    public String creationToken() {
        return creationToken;
    }

    /**
     * <p>
     * (Optional) ID of the file system whose description you want to retrieve (String).
     * </p>
     * 
     * @return (Optional) ID of the file system whose description you want to retrieve (String).
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsRequest)) {
            return false;
        }
        DescribeFileSystemsRequest other = (DescribeFileSystemsRequest) obj;
        return Objects.equals(maxItems(), other.maxItems()) && Objects.equals(marker(), other.marker())
                && Objects.equals(creationToken(), other.creationToken()) && Objects.equals(fileSystemId(), other.fileSystemId());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeFileSystemsRequest").add("MaxItems", maxItems()).add("Marker", marker())
                .add("CreationToken", creationToken()).add("FileSystemId", fileSystemId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxItems":
            return Optional.of(clazz.cast(maxItems()));
        case "Marker":
            return Optional.of(clazz.cast(marker()));
        case "CreationToken":
            return Optional.of(clazz.cast(creationToken()));
        case "FileSystemId":
            return Optional.of(clazz.cast(fileSystemId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EFSRequest.Builder, CopyableBuilder<Builder, DescribeFileSystemsRequest> {
        /**
         * <p>
         * (Optional) Specifies the maximum number of file systems to return in the response (integer). This parameter
         * value must be greater than 0. The number of items that Amazon EFS returns is the minimum of the
         * <code>MaxItems</code> parameter specified in the request and the service's internal maximum number of items
         * per page.
         * </p>
         * 
         * @param maxItems
         *        (Optional) Specifies the maximum number of file systems to return in the response (integer). This
         *        parameter value must be greater than 0. The number of items that Amazon EFS returns is the minimum of
         *        the <code>MaxItems</code> parameter specified in the request and the service's internal maximum number
         *        of items per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation
         * (String). If present, specifies to continue the list from where the returning call had left off.
         * </p>
         * 
         * @param marker
         *        (Optional) Opaque pagination token returned from a previous <code>DescribeFileSystems</code> operation
         *        (String). If present, specifies to continue the list from where the returning call had left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * (Optional) Restricts the list to the file system with this creation token (String). You specify a creation
         * token when you create an Amazon EFS file system.
         * </p>
         * 
         * @param creationToken
         *        (Optional) Restricts the list to the file system with this creation token (String). You specify a
         *        creation token when you create an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationToken(String creationToken);

        /**
         * <p>
         * (Optional) ID of the file system whose description you want to retrieve (String).
         * </p>
         * 
         * @param fileSystemId
         *        (Optional) ID of the file system whose description you want to retrieve (String).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends EFSRequest.BuilderImpl implements Builder {
        private Integer maxItems;

        private String marker;

        private String creationToken;

        private String fileSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFileSystemsRequest model) {
            maxItems(model.maxItems);
            marker(model.marker);
            creationToken(model.creationToken);
            fileSystemId(model.fileSystemId);
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getCreationToken() {
            return creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeFileSystemsRequest build() {
            return new DescribeFileSystemsRequest(this);
        }
    }
}
