/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.efs.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * FileSystemDescription JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class FileSystemDescriptionUnmarshaller implements Unmarshaller<FileSystemDescription, JsonUnmarshallerContext> {

    public FileSystemDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        FileSystemDescription.Builder fileSystemDescriptionBuilder = FileSystemDescription.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("OwnerId", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.ownerId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationToken", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.creationToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("FileSystemId", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.fileSystemId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationTime", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.creationTime(context.getUnmarshaller(java.time.Instant.class)
                            .unmarshall(context));
                }
                if (context.testExpression("LifeCycleState", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.lifeCycleState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.name(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("NumberOfMountTargets", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.numberOfMountTargets(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("SizeInBytes", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.sizeInBytes(FileSystemSizeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("PerformanceMode", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.performanceMode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Encrypted", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.encrypted(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("KmsKeyId", targetDepth)) {
                    context.nextToken();
                    fileSystemDescriptionBuilder.kmsKeyId(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return fileSystemDescriptionBuilder.build();
    }

    private static final FileSystemDescriptionUnmarshaller INSTANCE = new FileSystemDescriptionUnmarshaller();

    public static FileSystemDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
