/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.efs.model.MountTargetDescription;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link MountTargetDescription} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class MountTargetDescriptionMarshaller {
    private static final MarshallingInfo<String> OWNERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OwnerId").isBinary(false).build();

    private static final MarshallingInfo<String> MOUNTTARGETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MountTargetId").isBinary(false).build();

    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").isBinary(false).build();

    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();

    private static final MarshallingInfo<String> LIFECYCLESTATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LifeCycleState").isBinary(false).build();

    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").isBinary(false).build();

    private static final MarshallingInfo<String> NETWORKINTERFACEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetworkInterfaceId").isBinary(false).build();

    private static final MountTargetDescriptionMarshaller INSTANCE = new MountTargetDescriptionMarshaller();

    private MountTargetDescriptionMarshaller() {
    }

    public static MountTargetDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(MountTargetDescription mountTargetDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(mountTargetDescription, "mountTargetDescription");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(mountTargetDescription.ownerId(), OWNERID_BINDING);
            protocolMarshaller.marshall(mountTargetDescription.mountTargetId(), MOUNTTARGETID_BINDING);
            protocolMarshaller.marshall(mountTargetDescription.fileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall(mountTargetDescription.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall(mountTargetDescription.lifeCycleStateString(), LIFECYCLESTATE_BINDING);
            protocolMarshaller.marshall(mountTargetDescription.ipAddress(), IPADDRESS_BINDING);
            protocolMarshaller.marshall(mountTargetDescription.networkInterfaceId(), NETWORKINTERFACEID_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
