/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileSystemRequest extends EfsRequest implements
        ToCopyableBuilder<CreateFileSystemRequest.Builder, CreateFileSystemRequest> {
    private static final SdkField<String> CREATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemRequest::creationToken)).setter(setter(Builder::creationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationToken").build()).build();

    private static final SdkField<String> PERFORMANCE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemRequest::performanceModeAsString)).setter(setter(Builder::performanceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceMode").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateFileSystemRequest::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateFileSystemRequest::throughputModeAsString)).setter(setter(Builder::throughputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputMode").build()).build();

    private static final SdkField<Double> PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(CreateFileSystemRequest::provisionedThroughputInMibps))
            .setter(setter(Builder::provisionedThroughputInMibps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputInMibps")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateFileSystemRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TOKEN_FIELD,
            PERFORMANCE_MODE_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, THROUGHPUT_MODE_FIELD,
            PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD, TAGS_FIELD));

    private final String creationToken;

    private final String performanceMode;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String throughputMode;

    private final Double provisionedThroughputInMibps;

    private final List<Tag> tags;

    private CreateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.creationToken = builder.creationToken;
        this.performanceMode = builder.performanceMode;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.throughputMode = builder.throughputMode;
        this.provisionedThroughputInMibps = builder.provisionedThroughputInMibps;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
     * </p>
     * 
     * @return A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
     */
    public String creationToken() {
        return creationToken;
    }

    /**
     * <p>
     * The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for most file
     * systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate
     * throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The
     * performance mode can't be changed after the file system has been created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #performanceMode}
     * will return {@link PerformanceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #performanceModeAsString}.
     * </p>
     * 
     * @return The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for
     *         most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels
     *         of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most
     *         file operations. The performance mode can't be changed after the file system has been created.
     * @see PerformanceMode
     */
    public PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(performanceMode);
    }

    /**
     * <p>
     * The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for most file
     * systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of aggregate
     * throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The
     * performance mode can't be changed after the file system has been created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #performanceMode}
     * will return {@link PerformanceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #performanceModeAsString}.
     * </p>
     * 
     * @return The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for
     *         most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels
     *         of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most
     *         file operations. The performance mode can't be changed after the file system has been created.
     * @see PerformanceMode
     */
    public String performanceModeAsString() {
        return performanceMode;
    }

    /**
     * <p>
     * A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you have
     * the option of specifying <a>CreateFileSystemRequest$KmsKeyId</a> for an existing AWS Key Management Service (AWS
     * KMS) customer master key (CMK). If you don't specify a CMK, then the default CMK for Amazon EFS,
     * <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
     * </p>
     * 
     * @return A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system,
     *         you have the option of specifying <a>CreateFileSystemRequest$KmsKeyId</a> for an existing AWS Key
     *         Management Service (AWS KMS) customer master key (CMK). If you don't specify a CMK, then the default CMK
     *         for Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The ID of the AWS KMS CMK to be used to protect the encrypted file system. This parameter is only required if you
     * want to use a nondefault CMK. If this parameter is not specified, the default CMK for Amazon EFS is used. This ID
     * can be in one of the following formats:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * ARN - An Amazon Resource Name (ARN) for the key, for example
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Key alias ARN - An ARN for a key alias, for example
     * <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If <code>KmsKeyId</code> is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set to
     * true.
     * </p>
     * 
     * @return The ID of the AWS KMS CMK to be used to protect the encrypted file system. This parameter is only
     *         required if you want to use a nondefault CMK. If this parameter is not specified, the default CMK for
     *         Amazon EFS is used. This ID can be in one of the following formats:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ARN - An Amazon Resource Name (ARN) for the key, for example
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key alias ARN - An ARN for a key alias, for example
     *         <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If <code>KmsKeyId</code> is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set
     *         to true.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The throughput mode for the file system to be created. There are two throughput modes to choose from for your
     * file system: <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
     * <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You can
     * decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes as
     * long as it’s been more than 24 hours since the last decrease or throughput mode change. For more, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying Throughput
     * with Provisioned Mode</a> in the <i>Amazon EFS User Guide.</i>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #throughputMode}
     * will return {@link ThroughputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #throughputModeAsString}.
     * </p>
     * 
     * @return The throughput mode for the file system to be created. There are two throughput modes to choose from for
     *         your file system: <code>bursting</code> and <code>provisioned</code>. If you set
     *         <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for
     *         <code>ProvisionedThroughPutInMibps</code>. You can decrease your file system's throughput in Provisioned
     *         Throughput mode or change between the throughput modes as long as it’s been more than 24 hours since the
     *         last decrease or throughput mode change. For more, see <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying
     *         Throughput with Provisioned Mode</a> in the <i>Amazon EFS User Guide.</i>
     * @see ThroughputMode
     */
    public ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(throughputMode);
    }

    /**
     * <p>
     * The throughput mode for the file system to be created. There are two throughput modes to choose from for your
     * file system: <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
     * <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You can
     * decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes as
     * long as it’s been more than 24 hours since the last decrease or throughput mode change. For more, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying Throughput
     * with Provisioned Mode</a> in the <i>Amazon EFS User Guide.</i>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #throughputMode}
     * will return {@link ThroughputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #throughputModeAsString}.
     * </p>
     * 
     * @return The throughput mode for the file system to be created. There are two throughput modes to choose from for
     *         your file system: <code>bursting</code> and <code>provisioned</code>. If you set
     *         <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for
     *         <code>ProvisionedThroughPutInMibps</code>. You can decrease your file system's throughput in Provisioned
     *         Throughput mode or change between the throughput modes as long as it’s been more than 24 hours since the
     *         last decrease or throughput mode change. For more, see <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying
     *         Throughput with Provisioned Mode</a> in the <i>Amazon EFS User Guide.</i>
     * @see ThroughputMode
     */
    public String throughputModeAsString() {
        return throughputMode;
    }

    /**
     * <p>
     * The throughput, measured in MiB/s, that you want to provision for a file system that you're creating. Valid
     * values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code>. The upper limit
     * for throughput is 1024 MiB/s. You can get this limit increased by contacting AWS Support. For more information,
     * see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS Limits That You Can
     * Increase</a> in the <i>Amazon EFS User Guide.</i>
     * </p>
     * 
     * @return The throughput, measured in MiB/s, that you want to provision for a file system that you're creating.
     *         Valid values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code>. The
     *         upper limit for throughput is 1024 MiB/s. You can get this limit increased by contacting AWS Support. For
     *         more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon
     *         EFS Limits That You Can Increase</a> in the <i>Amazon EFS User Guide.</i>
     */
    public Double provisionedThroughputInMibps() {
        return provisionedThroughputInMibps;
    }

    /**
     * <p>
     * A value that specifies to create one or more tags associated with the file system. Each tag is a user-defined
     * key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code>
     * key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A value that specifies to create one or more tags associated with the file system. Each tag is a
     *         user-defined key-value pair. Name your file system on creation by including a
     *         <code>"Key":"Name","Value":"{value}"</code> key-value pair.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(performanceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputInMibps());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemRequest)) {
            return false;
        }
        CreateFileSystemRequest other = (CreateFileSystemRequest) obj;
        return Objects.equals(creationToken(), other.creationToken())
                && Objects.equals(performanceModeAsString(), other.performanceModeAsString())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(throughputModeAsString(), other.throughputModeAsString())
                && Objects.equals(provisionedThroughputInMibps(), other.provisionedThroughputInMibps())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateFileSystemRequest").add("CreationToken", creationToken())
                .add("PerformanceMode", performanceModeAsString()).add("Encrypted", encrypted()).add("KmsKeyId", kmsKeyId())
                .add("ThroughputMode", throughputModeAsString())
                .add("ProvisionedThroughputInMibps", provisionedThroughputInMibps()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationToken":
            return Optional.ofNullable(clazz.cast(creationToken()));
        case "PerformanceMode":
            return Optional.ofNullable(clazz.cast(performanceModeAsString()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ThroughputMode":
            return Optional.ofNullable(clazz.cast(throughputModeAsString()));
        case "ProvisionedThroughputInMibps":
            return Optional.ofNullable(clazz.cast(provisionedThroughputInMibps()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemRequest, T> g) {
        return obj -> g.apply((CreateFileSystemRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFileSystemRequest> {
        /**
         * <p>
         * A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
         * </p>
         * 
         * @param creationToken
         *        A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationToken(String creationToken);

        /**
         * <p>
         * The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for most
         * file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of
         * aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file
         * operations. The performance mode can't be changed after the file system has been created.
         * </p>
         * 
         * @param performanceMode
         *        The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for
         *        most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher
         *        levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies
         *        for most file operations. The performance mode can't be changed after the file system has been
         *        created.
         * @see PerformanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceMode
         */
        Builder performanceMode(String performanceMode);

        /**
         * <p>
         * The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for most
         * file systems. File systems using the <code>maxIO</code> performance mode can scale to higher levels of
         * aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file
         * operations. The performance mode can't be changed after the file system has been created.
         * </p>
         * 
         * @param performanceMode
         *        The performance mode of the file system. We recommend <code>generalPurpose</code> performance mode for
         *        most file systems. File systems using the <code>maxIO</code> performance mode can scale to higher
         *        levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies
         *        for most file operations. The performance mode can't be changed after the file system has been
         *        created.
         * @see PerformanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceMode
         */
        Builder performanceMode(PerformanceMode performanceMode);

        /**
         * <p>
         * A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you
         * have the option of specifying <a>CreateFileSystemRequest$KmsKeyId</a> for an existing AWS Key Management
         * Service (AWS KMS) customer master key (CMK). If you don't specify a CMK, then the default CMK for Amazon EFS,
         * <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file system.
         * </p>
         * 
         * @param encrypted
         *        A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file
         *        system, you have the option of specifying <a>CreateFileSystemRequest$KmsKeyId</a> for an existing AWS
         *        Key Management Service (AWS KMS) customer master key (CMK). If you don't specify a CMK, then the
         *        default CMK for Amazon EFS, <code>/aws/elasticfilesystem</code>, is used to protect the encrypted file
         *        system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The ID of the AWS KMS CMK to be used to protect the encrypted file system. This parameter is only required if
         * you want to use a nondefault CMK. If this parameter is not specified, the default CMK for Amazon EFS is used.
         * This ID can be in one of the following formats:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * ARN - An Amazon Resource Name (ARN) for the key, for example
         * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Key alias ARN - An ARN for a key alias, for example
         * <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If <code>KmsKeyId</code> is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be set to
         * true.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the AWS KMS CMK to be used to protect the encrypted file system. This parameter is only
         *        required if you want to use a nondefault CMK. If this parameter is not specified, the default CMK for
         *        Amazon EFS is used. This ID can be in one of the following formats:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ID - A unique identifier of the key, for example <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        .
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ARN - An Amazon Resource Name (ARN) for the key, for example
         *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias - A previously created display name for a key, for example <code>alias/projectKey1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Key alias ARN - An ARN for a key alias, for example
         *        <code>arn:aws:kms:us-west-2:444455556666:alias/projectKey1</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If <code>KmsKeyId</code> is specified, the <a>CreateFileSystemRequest$Encrypted</a> parameter must be
         *        set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The throughput mode for the file system to be created. There are two throughput modes to choose from for your
         * file system: <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
         * <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You can
         * decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes
         * as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more, see <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying
         * Throughput with Provisioned Mode</a> in the <i>Amazon EFS User Guide.</i>
         * </p>
         * 
         * @param throughputMode
         *        The throughput mode for the file system to be created. There are two throughput modes to choose from
         *        for your file system: <code>bursting</code> and <code>provisioned</code>. If you set
         *        <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for
         *        <code>ProvisionedThroughPutInMibps</code>. You can decrease your file system's throughput in
         *        Provisioned Throughput mode or change between the throughput modes as long as it’s been more than 24
         *        hours since the last decrease or throughput mode change. For more, see <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying
         *        Throughput with Provisioned Mode</a> in the <i>Amazon EFS User Guide.</i>
         * @see ThroughputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThroughputMode
         */
        Builder throughputMode(String throughputMode);

        /**
         * <p>
         * The throughput mode for the file system to be created. There are two throughput modes to choose from for your
         * file system: <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
         * <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You can
         * decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes
         * as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more, see <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying
         * Throughput with Provisioned Mode</a> in the <i>Amazon EFS User Guide.</i>
         * </p>
         * 
         * @param throughputMode
         *        The throughput mode for the file system to be created. There are two throughput modes to choose from
         *        for your file system: <code>bursting</code> and <code>provisioned</code>. If you set
         *        <code>ThroughputMode</code> to <code>provisioned</code>, you must also set a value for
         *        <code>ProvisionedThroughPutInMibps</code>. You can decrease your file system's throughput in
         *        Provisioned Throughput mode or change between the throughput modes as long as it’s been more than 24
         *        hours since the last decrease or throughput mode change. For more, see <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput">Specifying
         *        Throughput with Provisioned Mode</a> in the <i>Amazon EFS User Guide.</i>
         * @see ThroughputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThroughputMode
         */
        Builder throughputMode(ThroughputMode throughputMode);

        /**
         * <p>
         * The throughput, measured in MiB/s, that you want to provision for a file system that you're creating. Valid
         * values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code>. The upper
         * limit for throughput is 1024 MiB/s. You can get this limit increased by contacting AWS Support. For more
         * information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS
         * Limits That You Can Increase</a> in the <i>Amazon EFS User Guide.</i>
         * </p>
         * 
         * @param provisionedThroughputInMibps
         *        The throughput, measured in MiB/s, that you want to provision for a file system that you're creating.
         *        Valid values are 1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code>.
         *        The upper limit for throughput is 1024 MiB/s. You can get this limit increased by contacting AWS
         *        Support. For more information, see <a
         *        href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS Limits That You
         *        Can Increase</a> in the <i>Amazon EFS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps);

        /**
         * <p>
         * A value that specifies to create one or more tags associated with the file system. Each tag is a user-defined
         * key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code>
         * key-value pair.
         * </p>
         * 
         * @param tags
         *        A value that specifies to create one or more tags associated with the file system. Each tag is a
         *        user-defined key-value pair. Name your file system on creation by including a
         *        <code>"Key":"Name","Value":"{value}"</code> key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A value that specifies to create one or more tags associated with the file system. Each tag is a user-defined
         * key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code>
         * key-value pair.
         * </p>
         * 
         * @param tags
         *        A value that specifies to create one or more tags associated with the file system. Each tag is a
         *        user-defined key-value pair. Name your file system on creation by including a
         *        <code>"Key":"Name","Value":"{value}"</code> key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A value that specifies to create one or more tags associated with the file system. Each tag is a user-defined
         * key-value pair. Name your file system on creation by including a <code>"Key":"Name","Value":"{value}"</code>
         * key-value pair.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private String creationToken;

        private String performanceMode;

        private Boolean encrypted;

        private String kmsKeyId;

        private String throughputMode;

        private Double provisionedThroughputInMibps;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemRequest model) {
            super(model);
            creationToken(model.creationToken);
            performanceMode(model.performanceMode);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            throughputMode(model.throughputMode);
            provisionedThroughputInMibps(model.provisionedThroughputInMibps);
            tags(model.tags);
        }

        public final String getCreationToken() {
            return creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getPerformanceModeAsString() {
            return performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode == null ? null : performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getThroughputModeAsString() {
            return throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode == null ? null : throughputMode.toString());
            return this;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        public final Double getProvisionedThroughputInMibps() {
            return provisionedThroughputInMibps;
        }

        @Override
        public final Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        public final void setProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFileSystemRequest build() {
            return new CreateFileSystemRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
