/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMountTargetsRequest extends EfsRequest implements
        ToCopyableBuilder<DescribeMountTargetsRequest.Builder, DescribeMountTargetsRequest> {
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeMountTargetsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMountTargetsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMountTargetsRequest::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FileSystemId").build()).build();

    private static final SdkField<String> MOUNT_TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeMountTargetsRequest::mountTargetId)).setter(setter(Builder::mountTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MountTargetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ITEMS_FIELD, MARKER_FIELD,
            FILE_SYSTEM_ID_FIELD, MOUNT_TARGET_ID_FIELD));

    private final Integer maxItems;

    private final String marker;

    private final String fileSystemId;

    private final String mountTargetId;

    private DescribeMountTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.maxItems = builder.maxItems;
        this.marker = builder.marker;
        this.fileSystemId = builder.fileSystemId;
        this.mountTargetId = builder.mountTargetId;
    }

    /**
     * <p>
     * (Optional) Maximum number of mount targets to return in the response. Currently, this number is automatically set
     * to 10, and other values are ignored. The response is paginated at 10 per page if you have more than 10 mount
     * targets.
     * </p>
     * 
     * @return (Optional) Maximum number of mount targets to return in the response. Currently, this number is
     *         automatically set to 10, and other values are ignored. The response is paginated at 10 per page if you
     *         have more than 10 mount targets.
     */
    public Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * (Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code> operation (String).
     * If present, it specifies to continue the list from where the previous returning call left off.
     * </p>
     * 
     * @return (Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code> operation
     *         (String). If present, it specifies to continue the list from where the previous returning call left off.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * (Optional) ID of the file system whose mount targets you want to list (String). It must be included in your
     * request if <code>MountTargetId</code> is not included.
     * </p>
     * 
     * @return (Optional) ID of the file system whose mount targets you want to list (String). It must be included in
     *         your request if <code>MountTargetId</code> is not included.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * (Optional) ID of the mount target that you want to have described (String). It must be included in your request
     * if <code>FileSystemId</code> is not included.
     * </p>
     * 
     * @return (Optional) ID of the mount target that you want to have described (String). It must be included in your
     *         request if <code>FileSystemId</code> is not included.
     */
    public String mountTargetId() {
        return mountTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(mountTargetId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMountTargetsRequest)) {
            return false;
        }
        DescribeMountTargetsRequest other = (DescribeMountTargetsRequest) obj;
        return Objects.equals(maxItems(), other.maxItems()) && Objects.equals(marker(), other.marker())
                && Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(mountTargetId(), other.mountTargetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeMountTargetsRequest").add("MaxItems", maxItems()).add("Marker", marker())
                .add("FileSystemId", fileSystemId()).add("MountTargetId", mountTargetId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "MountTargetId":
            return Optional.ofNullable(clazz.cast(mountTargetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMountTargetsRequest, T> g) {
        return obj -> g.apply((DescribeMountTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMountTargetsRequest> {
        /**
         * <p>
         * (Optional) Maximum number of mount targets to return in the response. Currently, this number is automatically
         * set to 10, and other values are ignored. The response is paginated at 10 per page if you have more than 10
         * mount targets.
         * </p>
         * 
         * @param maxItems
         *        (Optional) Maximum number of mount targets to return in the response. Currently, this number is
         *        automatically set to 10, and other values are ignored. The response is paginated at 10 per page if you
         *        have more than 10 mount targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * (Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code> operation
         * (String). If present, it specifies to continue the list from where the previous returning call left off.
         * </p>
         * 
         * @param marker
         *        (Optional) Opaque pagination token returned from a previous <code>DescribeMountTargets</code>
         *        operation (String). If present, it specifies to continue the list from where the previous returning
         *        call left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * (Optional) ID of the file system whose mount targets you want to list (String). It must be included in your
         * request if <code>MountTargetId</code> is not included.
         * </p>
         * 
         * @param fileSystemId
         *        (Optional) ID of the file system whose mount targets you want to list (String). It must be included in
         *        your request if <code>MountTargetId</code> is not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * (Optional) ID of the mount target that you want to have described (String). It must be included in your
         * request if <code>FileSystemId</code> is not included.
         * </p>
         * 
         * @param mountTargetId
         *        (Optional) ID of the mount target that you want to have described (String). It must be included in
         *        your request if <code>FileSystemId</code> is not included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargetId(String mountTargetId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private Integer maxItems;

        private String marker;

        private String fileSystemId;

        private String mountTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMountTargetsRequest model) {
            super(model);
            maxItems(model.maxItems);
            marker(model.marker);
            fileSystemId(model.fileSystemId);
            mountTargetId(model.mountTargetId);
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getMountTargetId() {
            return mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMountTargetsRequest build() {
            return new DescribeMountTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
