/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemResponse extends EfsResponse implements
        ToCopyableBuilder<UpdateFileSystemResponse.Builder, UpdateFileSystemResponse> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemResponse::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> CREATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemResponse::creationToken)).setter(setter(Builder::creationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationToken").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemResponse::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(UpdateFileSystemResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> LIFE_CYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemResponse::lifeCycleStateAsString)).setter(setter(Builder::lifeCycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleState").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> NUMBER_OF_MOUNT_TARGETS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateFileSystemResponse::numberOfMountTargets)).setter(setter(Builder::numberOfMountTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMountTargets").build())
            .build();

    private static final SdkField<FileSystemSize> SIZE_IN_BYTES_FIELD = SdkField
            .<FileSystemSize> builder(MarshallingType.SDK_POJO).getter(getter(UpdateFileSystemResponse::sizeInBytes))
            .setter(setter(Builder::sizeInBytes)).constructor(FileSystemSize::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInBytes").build()).build();

    private static final SdkField<String> PERFORMANCE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemResponse::performanceModeAsString)).setter(setter(Builder::performanceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceMode").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateFileSystemResponse::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemResponse::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateFileSystemResponse::throughputModeAsString)).setter(setter(Builder::throughputMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputMode").build()).build();

    private static final SdkField<Double> PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(UpdateFileSystemResponse::provisionedThroughputInMibps))
            .setter(setter(Builder::provisionedThroughputInMibps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputInMibps")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(UpdateFileSystemResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD,
            CREATION_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD, CREATION_TIME_FIELD, LIFE_CYCLE_STATE_FIELD, NAME_FIELD,
            NUMBER_OF_MOUNT_TARGETS_FIELD, SIZE_IN_BYTES_FIELD, PERFORMANCE_MODE_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD,
            THROUGHPUT_MODE_FIELD, PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD, TAGS_FIELD));

    private final String ownerId;

    private final String creationToken;

    private final String fileSystemId;

    private final Instant creationTime;

    private final String lifeCycleState;

    private final String name;

    private final Integer numberOfMountTargets;

    private final FileSystemSize sizeInBytes;

    private final String performanceMode;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String throughputMode;

    private final Double provisionedThroughputInMibps;

    private final List<Tag> tags;

    private UpdateFileSystemResponse(BuilderImpl builder) {
        super(builder);
        this.ownerId = builder.ownerId;
        this.creationToken = builder.creationToken;
        this.fileSystemId = builder.fileSystemId;
        this.creationTime = builder.creationTime;
        this.lifeCycleState = builder.lifeCycleState;
        this.name = builder.name;
        this.numberOfMountTargets = builder.numberOfMountTargets;
        this.sizeInBytes = builder.sizeInBytes;
        this.performanceMode = builder.performanceMode;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.throughputMode = builder.throughputMode;
        this.provisionedThroughputInMibps = builder.provisionedThroughputInMibps;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The AWS account that created the file system. If the file system was created by an IAM user, the parent account
     * to which the user belongs is the owner.
     * </p>
     * 
     * @return The AWS account that created the file system. If the file system was created by an IAM user, the parent
     *         account to which the user belongs is the owner.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The opaque string specified in the request.
     * </p>
     * 
     * @return The opaque string specified in the request.
     */
    public String creationToken() {
        return creationToken;
    }

    /**
     * <p>
     * The ID of the file system, assigned by Amazon EFS.
     * </p>
     * 
     * @return The ID of the file system, assigned by Amazon EFS.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
     * </p>
     * 
     * @return The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The lifecycle phase of the file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateAsString}.
     * </p>
     * 
     * @return The lifecycle phase of the file system.
     * @see LifeCycleState
     */
    public LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(lifeCycleState);
    }

    /**
     * <p>
     * The lifecycle phase of the file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateAsString}.
     * </p>
     * 
     * @return The lifecycle phase of the file system.
     * @see LifeCycleState
     */
    public String lifeCycleStateAsString() {
        return lifeCycleState;
    }

    /**
     * <p>
     * You can add tags to a file system, including a <code>Name</code> tag. For more information, see
     * <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this
     * field.
     * </p>
     * 
     * @return You can add tags to a file system, including a <code>Name</code> tag. For more information, see
     *         <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in
     *         this field.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The current number of mount targets that the file system has. For more information, see <a>CreateMountTarget</a>.
     * </p>
     * 
     * @return The current number of mount targets that the file system has. For more information, see
     *         <a>CreateMountTarget</a>.
     */
    public Integer numberOfMountTargets() {
        return numberOfMountTargets;
    }

    /**
     * <p>
     * The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and
     * the time at which that size was determined in its <code>Timestamp</code> field. The <code>Timestamp</code> value
     * is the integer number of seconds since 1970-01-01T00:00:00Z. The <code>SizeInBytes</code> value doesn't represent
     * the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to
     * the file system. That is, <code>SizeInBytes</code> represents actual size only if the file system is not modified
     * for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was
     * at any point in time.
     * </p>
     * 
     * @return The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code>
     *         field, and the time at which that size was determined in its <code>Timestamp</code> field. The
     *         <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The
     *         <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system,
     *         but it is eventually consistent when there are no writes to the file system. That is,
     *         <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period
     *         longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any
     *         point in time.
     */
    public FileSystemSize sizeInBytes() {
        return sizeInBytes;
    }

    /**
     * <p>
     * The performance mode of the file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #performanceMode}
     * will return {@link PerformanceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #performanceModeAsString}.
     * </p>
     * 
     * @return The performance mode of the file system.
     * @see PerformanceMode
     */
    public PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(performanceMode);
    }

    /**
     * <p>
     * The performance mode of the file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #performanceMode}
     * will return {@link PerformanceMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #performanceModeAsString}.
     * </p>
     * 
     * @return The performance mode of the file system.
     * @see PerformanceMode
     */
    public String performanceModeAsString() {
        return performanceMode;
    }

    /**
     * <p>
     * A Boolean value that, if true, indicates that the file system is encrypted.
     * </p>
     * 
     * @return A Boolean value that, if true, indicates that the file system is encrypted.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The ID of an AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect the
     * encrypted file system.
     * </p>
     * 
     * @return The ID of an AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect the
     *         encrypted file system.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The throughput mode for a file system. There are two throughput modes to choose from for your file system:
     * <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
     * <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You can
     * decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes as
     * long as it’s been more than 24 hours since the last decrease or throughput mode change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #throughputMode}
     * will return {@link ThroughputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #throughputModeAsString}.
     * </p>
     * 
     * @return The throughput mode for a file system. There are two throughput modes to choose from for your file
     *         system: <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
     *         <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You
     *         can decrease your file system's throughput in Provisioned Throughput mode or change between the
     *         throughput modes as long as it’s been more than 24 hours since the last decrease or throughput mode
     *         change.
     * @see ThroughputMode
     */
    public ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(throughputMode);
    }

    /**
     * <p>
     * The throughput mode for a file system. There are two throughput modes to choose from for your file system:
     * <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
     * <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You can
     * decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes as
     * long as it’s been more than 24 hours since the last decrease or throughput mode change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #throughputMode}
     * will return {@link ThroughputMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #throughputModeAsString}.
     * </p>
     * 
     * @return The throughput mode for a file system. There are two throughput modes to choose from for your file
     *         system: <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
     *         <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You
     *         can decrease your file system's throughput in Provisioned Throughput mode or change between the
     *         throughput modes as long as it’s been more than 24 hours since the last decrease or throughput mode
     *         change.
     * @see ThroughputMode
     */
    public String throughputModeAsString() {
        return throughputMode;
    }

    /**
     * <p>
     * The throughput, measured in MiB/s, that you want to provision for a file system. Valid values are 1-1024.
     * Required if <code>ThroughputMode</code> is set to <code>provisioned</code>. The limit on throughput is 1024
     * MiB/s. You can get these limits increased by contacting AWS Support. For more information, see <a
     * href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS Limits That You Can
     * Increase</a> in the <i>Amazon EFS User Guide.</i>
     * </p>
     * 
     * @return The throughput, measured in MiB/s, that you want to provision for a file system. Valid values are 1-1024.
     *         Required if <code>ThroughputMode</code> is set to <code>provisioned</code>. The limit on throughput is
     *         1024 MiB/s. You can get these limits increased by contacting AWS Support. For more information, see <a
     *         href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS Limits That You Can
     *         Increase</a> in the <i>Amazon EFS User Guide.</i>
     */
    public Double provisionedThroughputInMibps() {
        return provisionedThroughputInMibps;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the file system, presented as an array of <code>Tag</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags associated with the file system, presented as an array of <code>Tag</code> objects.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfMountTargets());
        hashCode = 31 * hashCode + Objects.hashCode(sizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(performanceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughputInMibps());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemResponse)) {
            return false;
        }
        UpdateFileSystemResponse other = (UpdateFileSystemResponse) obj;
        return Objects.equals(ownerId(), other.ownerId()) && Objects.equals(creationToken(), other.creationToken())
                && Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lifeCycleStateAsString(), other.lifeCycleStateAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(numberOfMountTargets(), other.numberOfMountTargets())
                && Objects.equals(sizeInBytes(), other.sizeInBytes())
                && Objects.equals(performanceModeAsString(), other.performanceModeAsString())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(throughputModeAsString(), other.throughputModeAsString())
                && Objects.equals(provisionedThroughputInMibps(), other.provisionedThroughputInMibps())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateFileSystemResponse").add("OwnerId", ownerId()).add("CreationToken", creationToken())
                .add("FileSystemId", fileSystemId()).add("CreationTime", creationTime())
                .add("LifeCycleState", lifeCycleStateAsString()).add("Name", name())
                .add("NumberOfMountTargets", numberOfMountTargets()).add("SizeInBytes", sizeInBytes())
                .add("PerformanceMode", performanceModeAsString()).add("Encrypted", encrypted()).add("KmsKeyId", kmsKeyId())
                .add("ThroughputMode", throughputModeAsString())
                .add("ProvisionedThroughputInMibps", provisionedThroughputInMibps()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "CreationToken":
            return Optional.ofNullable(clazz.cast(creationToken()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LifeCycleState":
            return Optional.ofNullable(clazz.cast(lifeCycleStateAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NumberOfMountTargets":
            return Optional.ofNullable(clazz.cast(numberOfMountTargets()));
        case "SizeInBytes":
            return Optional.ofNullable(clazz.cast(sizeInBytes()));
        case "PerformanceMode":
            return Optional.ofNullable(clazz.cast(performanceModeAsString()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ThroughputMode":
            return Optional.ofNullable(clazz.cast(throughputModeAsString()));
        case "ProvisionedThroughputInMibps":
            return Optional.ofNullable(clazz.cast(provisionedThroughputInMibps()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemResponse, T> g) {
        return obj -> g.apply((UpdateFileSystemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFileSystemResponse> {
        /**
         * <p>
         * The AWS account that created the file system. If the file system was created by an IAM user, the parent
         * account to which the user belongs is the owner.
         * </p>
         * 
         * @param ownerId
         *        The AWS account that created the file system. If the file system was created by an IAM user, the
         *        parent account to which the user belongs is the owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The opaque string specified in the request.
         * </p>
         * 
         * @param creationToken
         *        The opaque string specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationToken(String creationToken);

        /**
         * <p>
         * The ID of the file system, assigned by Amazon EFS.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the file system, assigned by Amazon EFS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
         * </p>
         * 
         * @param creationTime
         *        The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The lifecycle phase of the file system.
         * </p>
         * 
         * @param lifeCycleState
         *        The lifecycle phase of the file system.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(String lifeCycleState);

        /**
         * <p>
         * The lifecycle phase of the file system.
         * </p>
         * 
         * @param lifeCycleState
         *        The lifecycle phase of the file system.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(LifeCycleState lifeCycleState);

        /**
         * <p>
         * You can add tags to a file system, including a <code>Name</code> tag. For more information, see
         * <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value in this
         * field.
         * </p>
         * 
         * @param name
         *        You can add tags to a file system, including a <code>Name</code> tag. For more information, see
         *        <a>CreateFileSystem</a>. If the file system has a <code>Name</code> tag, Amazon EFS returns the value
         *        in this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current number of mount targets that the file system has. For more information, see
         * <a>CreateMountTarget</a>.
         * </p>
         * 
         * @param numberOfMountTargets
         *        The current number of mount targets that the file system has. For more information, see
         *        <a>CreateMountTarget</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfMountTargets(Integer numberOfMountTargets);

        /**
         * <p>
         * The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field,
         * and the time at which that size was determined in its <code>Timestamp</code> field. The
         * <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The
         * <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it
         * is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code>
         * represents actual size only if the file system is not modified for a period longer than a couple of hours.
         * Otherwise, the value is not the exact size that the file system was at any point in time.
         * </p>
         * 
         * @param sizeInBytes
         *        The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code>
         *        field, and the time at which that size was determined in its <code>Timestamp</code> field. The
         *        <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The
         *        <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system,
         *        but it is eventually consistent when there are no writes to the file system. That is,
         *        <code>SizeInBytes</code> represents actual size only if the file system is not modified for a period
         *        longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at
         *        any point in time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeInBytes(FileSystemSize sizeInBytes);

        /**
         * <p>
         * The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field,
         * and the time at which that size was determined in its <code>Timestamp</code> field. The
         * <code>Timestamp</code> value is the integer number of seconds since 1970-01-01T00:00:00Z. The
         * <code>SizeInBytes</code> value doesn't represent the size of a consistent snapshot of the file system, but it
         * is eventually consistent when there are no writes to the file system. That is, <code>SizeInBytes</code>
         * represents actual size only if the file system is not modified for a period longer than a couple of hours.
         * Otherwise, the value is not the exact size that the file system was at any point in time.
         * </p>
         * This is a convenience that creates an instance of the {@link FileSystemSize.Builder} avoiding the need to
         * create one manually via {@link FileSystemSize#builder()}.
         *
         * When the {@link Consumer} completes, {@link FileSystemSize.Builder#build()} is called immediately and its
         * result is passed to {@link #sizeInBytes(FileSystemSize)}.
         * 
         * @param sizeInBytes
         *        a consumer that will call methods on {@link FileSystemSize.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sizeInBytes(FileSystemSize)
         */
        default Builder sizeInBytes(Consumer<FileSystemSize.Builder> sizeInBytes) {
            return sizeInBytes(FileSystemSize.builder().applyMutation(sizeInBytes).build());
        }

        /**
         * <p>
         * The performance mode of the file system.
         * </p>
         * 
         * @param performanceMode
         *        The performance mode of the file system.
         * @see PerformanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceMode
         */
        Builder performanceMode(String performanceMode);

        /**
         * <p>
         * The performance mode of the file system.
         * </p>
         * 
         * @param performanceMode
         *        The performance mode of the file system.
         * @see PerformanceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PerformanceMode
         */
        Builder performanceMode(PerformanceMode performanceMode);

        /**
         * <p>
         * A Boolean value that, if true, indicates that the file system is encrypted.
         * </p>
         * 
         * @param encrypted
         *        A Boolean value that, if true, indicates that the file system is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The ID of an AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect the
         * encrypted file system.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of an AWS Key Management Service (AWS KMS) customer master key (CMK) that was used to protect
         *        the encrypted file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The throughput mode for a file system. There are two throughput modes to choose from for your file system:
         * <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
         * <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You can
         * decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes
         * as long as it’s been more than 24 hours since the last decrease or throughput mode change.
         * </p>
         * 
         * @param throughputMode
         *        The throughput mode for a file system. There are two throughput modes to choose from for your file
         *        system: <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
         *        <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You
         *        can decrease your file system's throughput in Provisioned Throughput mode or change between the
         *        throughput modes as long as it’s been more than 24 hours since the last decrease or throughput mode
         *        change.
         * @see ThroughputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThroughputMode
         */
        Builder throughputMode(String throughputMode);

        /**
         * <p>
         * The throughput mode for a file system. There are two throughput modes to choose from for your file system:
         * <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
         * <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You can
         * decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes
         * as long as it’s been more than 24 hours since the last decrease or throughput mode change.
         * </p>
         * 
         * @param throughputMode
         *        The throughput mode for a file system. There are two throughput modes to choose from for your file
         *        system: <code>bursting</code> and <code>provisioned</code>. If you set <code>ThroughputMode</code> to
         *        <code>provisioned</code>, you must also set a value for <code>ProvisionedThroughPutInMibps</code>. You
         *        can decrease your file system's throughput in Provisioned Throughput mode or change between the
         *        throughput modes as long as it’s been more than 24 hours since the last decrease or throughput mode
         *        change.
         * @see ThroughputMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThroughputMode
         */
        Builder throughputMode(ThroughputMode throughputMode);

        /**
         * <p>
         * The throughput, measured in MiB/s, that you want to provision for a file system. Valid values are 1-1024.
         * Required if <code>ThroughputMode</code> is set to <code>provisioned</code>. The limit on throughput is 1024
         * MiB/s. You can get these limits increased by contacting AWS Support. For more information, see <a
         * href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon EFS Limits That You Can
         * Increase</a> in the <i>Amazon EFS User Guide.</i>
         * </p>
         * 
         * @param provisionedThroughputInMibps
         *        The throughput, measured in MiB/s, that you want to provision for a file system. Valid values are
         *        1-1024. Required if <code>ThroughputMode</code> is set to <code>provisioned</code>. The limit on
         *        throughput is 1024 MiB/s. You can get these limits increased by contacting AWS Support. For more
         *        information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits">Amazon
         *        EFS Limits That You Can Increase</a> in the <i>Amazon EFS User Guide.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps);

        /**
         * <p>
         * The tags associated with the file system, presented as an array of <code>Tag</code> objects.
         * </p>
         * 
         * @param tags
         *        The tags associated with the file system, presented as an array of <code>Tag</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the file system, presented as an array of <code>Tag</code> objects.
         * </p>
         * 
         * @param tags
         *        The tags associated with the file system, presented as an array of <code>Tag</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the file system, presented as an array of <code>Tag</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private String ownerId;

        private String creationToken;

        private String fileSystemId;

        private Instant creationTime;

        private String lifeCycleState;

        private String name;

        private Integer numberOfMountTargets;

        private FileSystemSize sizeInBytes;

        private String performanceMode;

        private Boolean encrypted;

        private String kmsKeyId;

        private String throughputMode;

        private Double provisionedThroughputInMibps;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemResponse model) {
            super(model);
            ownerId(model.ownerId);
            creationToken(model.creationToken);
            fileSystemId(model.fileSystemId);
            creationTime(model.creationTime);
            lifeCycleState(model.lifeCycleState);
            name(model.name);
            numberOfMountTargets(model.numberOfMountTargets);
            sizeInBytes(model.sizeInBytes);
            performanceMode(model.performanceMode);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            throughputMode(model.throughputMode);
            provisionedThroughputInMibps(model.provisionedThroughputInMibps);
            tags(model.tags);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCreationToken() {
            return creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getLifeCycleStateAsString() {
            return lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState == null ? null : lifeCycleState.toString());
            return this;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getNumberOfMountTargets() {
            return numberOfMountTargets;
        }

        @Override
        public final Builder numberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
            return this;
        }

        public final void setNumberOfMountTargets(Integer numberOfMountTargets) {
            this.numberOfMountTargets = numberOfMountTargets;
        }

        public final FileSystemSize.Builder getSizeInBytes() {
            return sizeInBytes != null ? sizeInBytes.toBuilder() : null;
        }

        @Override
        public final Builder sizeInBytes(FileSystemSize sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
            return this;
        }

        public final void setSizeInBytes(FileSystemSize.BuilderImpl sizeInBytes) {
            this.sizeInBytes = sizeInBytes != null ? sizeInBytes.build() : null;
        }

        public final String getPerformanceModeAsString() {
            return performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode == null ? null : performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getThroughputModeAsString() {
            return throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode == null ? null : throughputMode.toString());
            return this;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        public final Double getProvisionedThroughputInMibps() {
            return provisionedThroughputInMibps;
        }

        @Override
        public final Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        public final void setProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public UpdateFileSystemResponse build() {
            return new UpdateFileSystemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
