/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is
 * used for all file system operations performed by NFS clients using the access point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PosixUser implements SdkPojo, Serializable, ToCopyableBuilder<PosixUser.Builder, PosixUser> {
    private static final SdkField<Long> UID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).getter(getter(PosixUser::uid))
            .setter(setter(Builder::uid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uid").build()).build();

    private static final SdkField<Long> GID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).getter(getter(PosixUser::gid))
            .setter(setter(Builder::gid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gid").build()).build();

    private static final SdkField<List<Long>> SECONDARY_GIDS_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .getter(getter(PosixUser::secondaryGids))
            .setter(setter(Builder::secondaryGids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryGids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, GID_FIELD,
            SECONDARY_GIDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long uid;

    private final Long gid;

    private final List<Long> secondaryGids;

    private PosixUser(BuilderImpl builder) {
        this.uid = builder.uid;
        this.gid = builder.gid;
        this.secondaryGids = builder.secondaryGids;
    }

    /**
     * <p>
     * The POSIX user ID used for all file system operations using this access point.
     * </p>
     * 
     * @return The POSIX user ID used for all file system operations using this access point.
     */
    public Long uid() {
        return uid;
    }

    /**
     * <p>
     * The POSIX group ID used for all file system operations using this access point.
     * </p>
     * 
     * @return The POSIX group ID used for all file system operations using this access point.
     */
    public Long gid() {
        return gid;
    }

    /**
     * Returns true if the SecondaryGids property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSecondaryGids() {
        return secondaryGids != null && !(secondaryGids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Secondary POSIX group IDs used for all file system operations using this access point.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecondaryGids()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Secondary POSIX group IDs used for all file system operations using this access point.
     */
    public List<Long> secondaryGids() {
        return secondaryGids;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uid());
        hashCode = 31 * hashCode + Objects.hashCode(gid());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryGids());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PosixUser)) {
            return false;
        }
        PosixUser other = (PosixUser) obj;
        return Objects.equals(uid(), other.uid()) && Objects.equals(gid(), other.gid())
                && Objects.equals(secondaryGids(), other.secondaryGids());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PosixUser").add("Uid", uid()).add("Gid", gid()).add("SecondaryGids", secondaryGids()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uid":
            return Optional.ofNullable(clazz.cast(uid()));
        case "Gid":
            return Optional.ofNullable(clazz.cast(gid()));
        case "SecondaryGids":
            return Optional.ofNullable(clazz.cast(secondaryGids()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PosixUser, T> g) {
        return obj -> g.apply((PosixUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PosixUser> {
        /**
         * <p>
         * The POSIX user ID used for all file system operations using this access point.
         * </p>
         * 
         * @param uid
         *        The POSIX user ID used for all file system operations using this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uid(Long uid);

        /**
         * <p>
         * The POSIX group ID used for all file system operations using this access point.
         * </p>
         * 
         * @param gid
         *        The POSIX group ID used for all file system operations using this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gid(Long gid);

        /**
         * <p>
         * Secondary POSIX group IDs used for all file system operations using this access point.
         * </p>
         * 
         * @param secondaryGids
         *        Secondary POSIX group IDs used for all file system operations using this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryGids(Collection<Long> secondaryGids);

        /**
         * <p>
         * Secondary POSIX group IDs used for all file system operations using this access point.
         * </p>
         * 
         * @param secondaryGids
         *        Secondary POSIX group IDs used for all file system operations using this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryGids(Long... secondaryGids);
    }

    static final class BuilderImpl implements Builder {
        private Long uid;

        private Long gid;

        private List<Long> secondaryGids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PosixUser model) {
            uid(model.uid);
            gid(model.gid);
            secondaryGids(model.secondaryGids);
        }

        public final Long getUid() {
            return uid;
        }

        @Override
        public final Builder uid(Long uid) {
            this.uid = uid;
            return this;
        }

        public final void setUid(Long uid) {
            this.uid = uid;
        }

        public final Long getGid() {
            return gid;
        }

        @Override
        public final Builder gid(Long gid) {
            this.gid = gid;
            return this;
        }

        public final void setGid(Long gid) {
            this.gid = gid;
        }

        public final Collection<Long> getSecondaryGids() {
            return secondaryGids;
        }

        @Override
        public final Builder secondaryGids(Collection<Long> secondaryGids) {
            this.secondaryGids = SecondaryGidsCopier.copy(secondaryGids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryGids(Long... secondaryGids) {
            secondaryGids(Arrays.asList(secondaryGids));
            return this;
        }

        public final void setSecondaryGids(Collection<Long> secondaryGids) {
            this.secondaryGids = SecondaryGidsCopier.copy(secondaryGids);
        }

        @Override
        public PosixUser build() {
            return new PosixUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
