/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The latest known metered size (in bytes) of data stored in the file system, in its <code>Value</code> field, and the
 * time at which that size was determined in its <code>Timestamp</code> field. The value doesn't represent the size of a
 * consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system.
 * That is, the value represents the actual size only if the file system is not modified for a period longer than a
 * couple of hours. Otherwise, the value is not necessarily the exact size the file system was at any instant in time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSystemSize implements SdkPojo, Serializable, ToCopyableBuilder<FileSystemSize.Builder, FileSystemSize> {
    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(FileSystemSize::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(FileSystemSize::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Long> VALUE_IN_IA_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(FileSystemSize::valueInIA)).setter(setter(Builder::valueInIA))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueInIA").build()).build();

    private static final SdkField<Long> VALUE_IN_STANDARD_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(FileSystemSize::valueInStandard)).setter(setter(Builder::valueInStandard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueInStandard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TIMESTAMP_FIELD,
            VALUE_IN_IA_FIELD, VALUE_IN_STANDARD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long value;

    private final Instant timestamp;

    private final Long valueInIA;

    private final Long valueInStandard;

    private FileSystemSize(BuilderImpl builder) {
        this.value = builder.value;
        this.timestamp = builder.timestamp;
        this.valueInIA = builder.valueInIA;
        this.valueInStandard = builder.valueInStandard;
    }

    /**
     * <p>
     * The latest known metered size (in bytes) of data stored in the file system.
     * </p>
     * 
     * @return The latest known metered size (in bytes) of data stored in the file system.
     */
    public Long value() {
        return value;
    }

    /**
     * <p>
     * The time at which the size of data, returned in the <code>Value</code> field, was determined. The value is the
     * integer number of seconds since 1970-01-01T00:00:00Z.
     * </p>
     * 
     * @return The time at which the size of data, returned in the <code>Value</code> field, was determined. The value
     *         is the integer number of seconds since 1970-01-01T00:00:00Z.
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
     * </p>
     * 
     * @return The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
     */
    public Long valueInIA() {
        return valueInIA;
    }

    /**
     * <p>
     * The latest known metered size (in bytes) of data stored in the Standard storage class.
     * </p>
     * 
     * @return The latest known metered size (in bytes) of data stored in the Standard storage class.
     */
    public Long valueInStandard() {
        return valueInStandard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(valueInIA());
        hashCode = 31 * hashCode + Objects.hashCode(valueInStandard());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemSize)) {
            return false;
        }
        FileSystemSize other = (FileSystemSize) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(valueInIA(), other.valueInIA()) && Objects.equals(valueInStandard(), other.valueInStandard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FileSystemSize").add("Value", value()).add("Timestamp", timestamp())
                .add("ValueInIA", valueInIA()).add("ValueInStandard", valueInStandard()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "ValueInIA":
            return Optional.ofNullable(clazz.cast(valueInIA()));
        case "ValueInStandard":
            return Optional.ofNullable(clazz.cast(valueInStandard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemSize, T> g) {
        return obj -> g.apply((FileSystemSize) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSystemSize> {
        /**
         * <p>
         * The latest known metered size (in bytes) of data stored in the file system.
         * </p>
         * 
         * @param value
         *        The latest known metered size (in bytes) of data stored in the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);

        /**
         * <p>
         * The time at which the size of data, returned in the <code>Value</code> field, was determined. The value is
         * the integer number of seconds since 1970-01-01T00:00:00Z.
         * </p>
         * 
         * @param timestamp
         *        The time at which the size of data, returned in the <code>Value</code> field, was determined. The
         *        value is the integer number of seconds since 1970-01-01T00:00:00Z.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
         * </p>
         * 
         * @param valueInIA
         *        The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueInIA(Long valueInIA);

        /**
         * <p>
         * The latest known metered size (in bytes) of data stored in the Standard storage class.
         * </p>
         * 
         * @param valueInStandard
         *        The latest known metered size (in bytes) of data stored in the Standard storage class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueInStandard(Long valueInStandard);
    }

    static final class BuilderImpl implements Builder {
        private Long value;

        private Instant timestamp;

        private Long valueInIA;

        private Long valueInStandard;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemSize model) {
            value(model.value);
            timestamp(model.timestamp);
            valueInIA(model.valueInIA);
            valueInStandard(model.valueInStandard);
        }

        public final Long getValue() {
            return value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Long getValueInIA() {
            return valueInIA;
        }

        @Override
        public final Builder valueInIA(Long valueInIA) {
            this.valueInIA = valueInIA;
            return this;
        }

        public final void setValueInIA(Long valueInIA) {
            this.valueInIA = valueInIA;
        }

        public final Long getValueInStandard() {
            return valueInStandard;
        }

        @Override
        public final Builder valueInStandard(Long valueInStandard) {
            this.valueInStandard = valueInStandard;
            return this;
        }

        public final void setValueInStandard(Long valueInStandard) {
            this.valueInStandard = valueInStandard;
        }

        @Override
        public FileSystemSize build() {
            return new FileSystemSize(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
