/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a description of a mount target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MountTargetDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<MountTargetDescription.Builder, MountTargetDescription> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountTargetDescription::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> MOUNT_TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountTargetDescription::mountTargetId)).setter(setter(Builder::mountTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountTargetId").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountTargetDescription::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountTargetDescription::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> LIFE_CYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountTargetDescription::lifeCycleStateAsString)).setter(setter(Builder::lifeCycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleState").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountTargetDescription::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountTargetDescription::networkInterfaceId)).setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountTargetDescription::availabilityZoneId)).setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MountTargetDescription::availabilityZoneName)).setter(setter(Builder::availabilityZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD,
            MOUNT_TARGET_ID_FIELD, FILE_SYSTEM_ID_FIELD, SUBNET_ID_FIELD, LIFE_CYCLE_STATE_FIELD, IP_ADDRESS_FIELD,
            NETWORK_INTERFACE_ID_FIELD, AVAILABILITY_ZONE_ID_FIELD, AVAILABILITY_ZONE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ownerId;

    private final String mountTargetId;

    private final String fileSystemId;

    private final String subnetId;

    private final String lifeCycleState;

    private final String ipAddress;

    private final String networkInterfaceId;

    private final String availabilityZoneId;

    private final String availabilityZoneName;

    private MountTargetDescription(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.mountTargetId = builder.mountTargetId;
        this.fileSystemId = builder.fileSystemId;
        this.subnetId = builder.subnetId;
        this.lifeCycleState = builder.lifeCycleState;
        this.ipAddress = builder.ipAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availabilityZoneName = builder.availabilityZoneName;
    }

    /**
     * <p>
     * AWS account ID that owns the resource.
     * </p>
     * 
     * @return AWS account ID that owns the resource.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * System-assigned mount target ID.
     * </p>
     * 
     * @return System-assigned mount target ID.
     */
    public String mountTargetId() {
        return mountTargetId;
    }

    /**
     * <p>
     * The ID of the file system for which the mount target is intended.
     * </p>
     * 
     * @return The ID of the file system for which the mount target is intended.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The ID of the mount target's subnet.
     * </p>
     * 
     * @return The ID of the mount target's subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * Lifecycle state of the mount target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateAsString}.
     * </p>
     * 
     * @return Lifecycle state of the mount target.
     * @see LifeCycleState
     */
    public LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(lifeCycleState);
    }

    /**
     * <p>
     * Lifecycle state of the mount target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateAsString}.
     * </p>
     * 
     * @return Lifecycle state of the mount target.
     * @see LifeCycleState
     */
    public String lifeCycleStateAsString() {
        return lifeCycleState;
    }

    /**
     * <p>
     * Address at which the file system can be mounted by using the mount target.
     * </p>
     * 
     * @return Address at which the file system can be mounted by using the mount target.
     */
    public String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The ID of the network interface that Amazon EFS created when it created the mount target.
     * </p>
     * 
     * @return The ID of the network interface that Amazon EFS created when it created the mount target.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The unique and consistent identifier of the Availability Zone (AZ) that the mount target resides in. For example,
     * <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every AWS account.
     * </p>
     * 
     * @return The unique and consistent identifier of the Availability Zone (AZ) that the mount target resides in. For
     *         example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every
     *         AWS account.
     */
    public String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The name of the Availability Zone (AZ) that the mount target resides in. AZs are independently mapped to names
     * for each AWS account. For example, the Availability Zone <code>us-east-1a</code> for your AWS account might not
     * be the same location as <code>us-east-1a</code> for another AWS account.
     * </p>
     * 
     * @return The name of the Availability Zone (AZ) that the mount target resides in. AZs are independently mapped to
     *         names for each AWS account. For example, the Availability Zone <code>us-east-1a</code> for your AWS
     *         account might not be the same location as <code>us-east-1a</code> for another AWS account.
     */
    public String availabilityZoneName() {
        return availabilityZoneName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(mountTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountTargetDescription)) {
            return false;
        }
        MountTargetDescription other = (MountTargetDescription) obj;
        return Objects.equals(ownerId(), other.ownerId()) && Objects.equals(mountTargetId(), other.mountTargetId())
                && Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(lifeCycleStateAsString(), other.lifeCycleStateAsString())
                && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(availabilityZoneName(), other.availabilityZoneName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MountTargetDescription").add("OwnerId", ownerId()).add("MountTargetId", mountTargetId())
                .add("FileSystemId", fileSystemId()).add("SubnetId", subnetId()).add("LifeCycleState", lifeCycleStateAsString())
                .add("IpAddress", ipAddress()).add("NetworkInterfaceId", networkInterfaceId())
                .add("AvailabilityZoneId", availabilityZoneId()).add("AvailabilityZoneName", availabilityZoneName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "MountTargetId":
            return Optional.ofNullable(clazz.cast(mountTargetId()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "LifeCycleState":
            return Optional.ofNullable(clazz.cast(lifeCycleStateAsString()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "AvailabilityZoneName":
            return Optional.ofNullable(clazz.cast(availabilityZoneName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MountTargetDescription, T> g) {
        return obj -> g.apply((MountTargetDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MountTargetDescription> {
        /**
         * <p>
         * AWS account ID that owns the resource.
         * </p>
         * 
         * @param ownerId
         *        AWS account ID that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * System-assigned mount target ID.
         * </p>
         * 
         * @param mountTargetId
         *        System-assigned mount target ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargetId(String mountTargetId);

        /**
         * <p>
         * The ID of the file system for which the mount target is intended.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the file system for which the mount target is intended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The ID of the mount target's subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the mount target's subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Lifecycle state of the mount target.
         * </p>
         * 
         * @param lifeCycleState
         *        Lifecycle state of the mount target.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(String lifeCycleState);

        /**
         * <p>
         * Lifecycle state of the mount target.
         * </p>
         * 
         * @param lifeCycleState
         *        Lifecycle state of the mount target.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(LifeCycleState lifeCycleState);

        /**
         * <p>
         * Address at which the file system can be mounted by using the mount target.
         * </p>
         * 
         * @param ipAddress
         *        Address at which the file system can be mounted by using the mount target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The ID of the network interface that Amazon EFS created when it created the mount target.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface that Amazon EFS created when it created the mount target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The unique and consistent identifier of the Availability Zone (AZ) that the mount target resides in. For
         * example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every AWS
         * account.
         * </p>
         * 
         * @param availabilityZoneId
         *        The unique and consistent identifier of the Availability Zone (AZ) that the mount target resides in.
         *        For example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location
         *        in every AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The name of the Availability Zone (AZ) that the mount target resides in. AZs are independently mapped to
         * names for each AWS account. For example, the Availability Zone <code>us-east-1a</code> for your AWS account
         * might not be the same location as <code>us-east-1a</code> for another AWS account.
         * </p>
         * 
         * @param availabilityZoneName
         *        The name of the Availability Zone (AZ) that the mount target resides in. AZs are independently mapped
         *        to names for each AWS account. For example, the Availability Zone <code>us-east-1a</code> for your AWS
         *        account might not be the same location as <code>us-east-1a</code> for another AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneName(String availabilityZoneName);
    }

    static final class BuilderImpl implements Builder {
        private String ownerId;

        private String mountTargetId;

        private String fileSystemId;

        private String subnetId;

        private String lifeCycleState;

        private String ipAddress;

        private String networkInterfaceId;

        private String availabilityZoneId;

        private String availabilityZoneName;

        private BuilderImpl() {
        }

        private BuilderImpl(MountTargetDescription model) {
            ownerId(model.ownerId);
            mountTargetId(model.mountTargetId);
            fileSystemId(model.fileSystemId);
            subnetId(model.subnetId);
            lifeCycleState(model.lifeCycleState);
            ipAddress(model.ipAddress);
            networkInterfaceId(model.networkInterfaceId);
            availabilityZoneId(model.availabilityZoneId);
            availabilityZoneName(model.availabilityZoneName);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getMountTargetId() {
            return mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getLifeCycleStateAsString() {
            return lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState == null ? null : lifeCycleState.toString());
            return this;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        public final String getAvailabilityZoneName() {
            return availabilityZoneName;
        }

        @Override
        public final Builder availabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
            return this;
        }

        public final void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        @Override
        public MountTargetDescription build() {
            return new MountTargetDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
