/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccessPointsRequest extends EfsRequest implements
        ToCopyableBuilder<DescribeAccessPointsRequest.Builder, DescribeAccessPointsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeAccessPointsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAccessPointsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAccessPointsRequest::accessPointId)).setter(setter(Builder::accessPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AccessPointId").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeAccessPointsRequest::fileSystemId)).setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FileSystemId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, ACCESS_POINT_ID_FIELD, FILE_SYSTEM_ID_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String accessPointId;

    private final String fileSystemId;

    private DescribeAccessPointsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.accessPointId = builder.accessPointId;
        this.fileSystemId = builder.fileSystemId;
    }

    /**
     * <p>
     * (Optional) When retrieving all access points for a file system, you can optionally specify the
     * <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is 100.
     * </p>
     * 
     * @return (Optional) When retrieving all access points for a file system, you can optionally specify the
     *         <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value
     *         is 100.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the
     * subsequent request to fetch the next page of access point descriptions.
     * </p>
     * 
     * @return <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in
     *         the subsequent request to fetch the next page of access point descriptions.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * (Optional) Specifies an EFS access point to describe in the response; mutually exclusive with
     * <code>FileSystemId</code>.
     * </p>
     * 
     * @return (Optional) Specifies an EFS access point to describe in the response; mutually exclusive with
     *         <code>FileSystemId</code>.
     */
    public String accessPointId() {
        return accessPointId;
    }

    /**
     * <p>
     * (Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system;
     * mutually exclusive with <code>AccessPointId</code>.
     * </p>
     * 
     * @return (Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file
     *         system; mutually exclusive with <code>AccessPointId</code>.
     */
    public String fileSystemId() {
        return fileSystemId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(accessPointId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccessPointsRequest)) {
            return false;
        }
        DescribeAccessPointsRequest other = (DescribeAccessPointsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(accessPointId(), other.accessPointId()) && Objects.equals(fileSystemId(), other.fileSystemId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAccessPointsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("AccessPointId", accessPointId()).add("FileSystemId", fileSystemId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "AccessPointId":
            return Optional.ofNullable(clazz.cast(accessPointId()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccessPointsRequest, T> g) {
        return obj -> g.apply((DescribeAccessPointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAccessPointsRequest> {
        /**
         * <p>
         * (Optional) When retrieving all access points for a file system, you can optionally specify the
         * <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default value is
         * 100.
         * </p>
         * 
         * @param maxResults
         *        (Optional) When retrieving all access points for a file system, you can optionally specify the
         *        <code>MaxItems</code> parameter to limit the number of objects returned in a response. The default
         *        value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in the
         * subsequent request to fetch the next page of access point descriptions.
         * </p>
         * 
         * @param nextToken
         *        <code>NextToken</code> is present if the response is paginated. You can use <code>NextMarker</code> in
         *        the subsequent request to fetch the next page of access point descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * (Optional) Specifies an EFS access point to describe in the response; mutually exclusive with
         * <code>FileSystemId</code>.
         * </p>
         * 
         * @param accessPointId
         *        (Optional) Specifies an EFS access point to describe in the response; mutually exclusive with
         *        <code>FileSystemId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointId(String accessPointId);

        /**
         * <p>
         * (Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file system;
         * mutually exclusive with <code>AccessPointId</code>.
         * </p>
         * 
         * @param fileSystemId
         *        (Optional) If you provide a <code>FileSystemId</code>, EFS returns all access points for that file
         *        system; mutually exclusive with <code>AccessPointId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EfsRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String accessPointId;

        private String fileSystemId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccessPointsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            accessPointId(model.accessPointId);
            fileSystemId(model.fileSystemId);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getAccessPointId() {
            return accessPointId;
        }

        @Override
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAccessPointsRequest build() {
            return new DescribeAccessPointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
