/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returned if the access point you are trying to create already exists, with the creation token you provided in the
 * request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessPointAlreadyExistsException extends EfsException implements
        ToCopyableBuilder<AccessPointAlreadyExistsException.Builder, AccessPointAlreadyExistsException> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessPointAlreadyExistsException::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessPointAlreadyExistsException::accessPointId)).setter(setter(Builder::accessPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ACCESS_POINT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String accessPointId;

    private AccessPointAlreadyExistsException(BuilderImpl builder) {
        super(builder);
        this.errorCode = builder.errorCode;
        this.accessPointId = builder.accessPointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the ErrorCode property for this object.
     * 
     * @return The value of the ErrorCode property for this object.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * Returns the value of the AccessPointId property for this object.
     * 
     * @return The value of the AccessPointId property for this object.
     */
    public String accessPointId() {
        return accessPointId;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPointAlreadyExistsException, T> g) {
        return obj -> g.apply((AccessPointAlreadyExistsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessPointAlreadyExistsException>, EfsException.Builder {
        /**
         * Sets the value of the ErrorCode property for this object.
         *
         * @param errorCode
         *        The new value for the ErrorCode property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * Sets the value of the AccessPointId property for this object.
         *
         * @param accessPointId
         *        The new value for the AccessPointId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointId(String accessPointId);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends EfsException.BuilderImpl implements Builder {
        private String errorCode;

        private String accessPointId;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPointAlreadyExistsException model) {
            super(model);
            errorCode(model.errorCode);
            accessPointId(model.accessPointId);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getAccessPointId() {
            return accessPointId;
        }

        @Override
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public AccessPointAlreadyExistsException build() {
            return new AccessPointAlreadyExistsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
