/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutLifecycleConfigurationResponse extends EfsResponse implements
        ToCopyableBuilder<PutLifecycleConfigurationResponse.Builder, PutLifecycleConfigurationResponse> {
    private static final SdkField<List<LifecyclePolicy>> LIFECYCLE_POLICIES_FIELD = SdkField
            .<List<LifecyclePolicy>> builder(MarshallingType.LIST)
            .memberName("LifecyclePolicies")
            .getter(getter(PutLifecycleConfigurationResponse::lifecyclePolicies))
            .setter(setter(Builder::lifecyclePolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecyclePolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_POLICIES_FIELD));

    private final List<LifecyclePolicy> lifecyclePolicies;

    private PutLifecycleConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicies = builder.lifecyclePolicies;
    }

    /**
     * Returns true if the LifecyclePolicies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLifecyclePolicies() {
        return lifecyclePolicies != null && !(lifecyclePolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of lifecycle management policies. Currently, EFS supports a maximum of one policy per file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLifecyclePolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of lifecycle management policies. Currently, EFS supports a maximum of one policy per file
     *         system.
     */
    public List<LifecyclePolicy> lifecyclePolicies() {
        return lifecyclePolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecyclePolicies() ? lifecyclePolicies() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecycleConfigurationResponse)) {
            return false;
        }
        PutLifecycleConfigurationResponse other = (PutLifecycleConfigurationResponse) obj;
        return hasLifecyclePolicies() == other.hasLifecyclePolicies()
                && Objects.equals(lifecyclePolicies(), other.lifecyclePolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutLifecycleConfigurationResponse")
                .add("LifecyclePolicies", hasLifecyclePolicies() ? lifecyclePolicies() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecyclePolicies":
            return Optional.ofNullable(clazz.cast(lifecyclePolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutLifecycleConfigurationResponse, T> g) {
        return obj -> g.apply((PutLifecycleConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutLifecycleConfigurationResponse> {
        /**
         * <p>
         * An array of lifecycle management policies. Currently, EFS supports a maximum of one policy per file system.
         * </p>
         * 
         * @param lifecyclePolicies
         *        An array of lifecycle management policies. Currently, EFS supports a maximum of one policy per file
         *        system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicies(Collection<LifecyclePolicy> lifecyclePolicies);

        /**
         * <p>
         * An array of lifecycle management policies. Currently, EFS supports a maximum of one policy per file system.
         * </p>
         * 
         * @param lifecyclePolicies
         *        An array of lifecycle management policies. Currently, EFS supports a maximum of one policy per file
         *        system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicies(LifecyclePolicy... lifecyclePolicies);

        /**
         * <p>
         * An array of lifecycle management policies. Currently, EFS supports a maximum of one policy per file system.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LifecyclePolicy>.Builder} avoiding the need
         * to create one manually via {@link List<LifecyclePolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LifecyclePolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #lifecyclePolicies(List<LifecyclePolicy>)}.
         * 
         * @param lifecyclePolicies
         *        a consumer that will call methods on {@link List<LifecyclePolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecyclePolicies(List<LifecyclePolicy>)
         */
        Builder lifecyclePolicies(Consumer<LifecyclePolicy.Builder>... lifecyclePolicies);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private List<LifecyclePolicy> lifecyclePolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutLifecycleConfigurationResponse model) {
            super(model);
            lifecyclePolicies(model.lifecyclePolicies);
        }

        public final Collection<LifecyclePolicy.Builder> getLifecyclePolicies() {
            if (lifecyclePolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return lifecyclePolicies != null ? lifecyclePolicies.stream().map(LifecyclePolicy::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lifecyclePolicies(Collection<LifecyclePolicy> lifecyclePolicies) {
            this.lifecyclePolicies = LifecyclePoliciesCopier.copy(lifecyclePolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicies(LifecyclePolicy... lifecyclePolicies) {
            lifecyclePolicies(Arrays.asList(lifecyclePolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicies(Consumer<LifecyclePolicy.Builder>... lifecyclePolicies) {
            lifecyclePolicies(Stream.of(lifecyclePolicies).map(c -> LifecyclePolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLifecyclePolicies(Collection<LifecyclePolicy.BuilderImpl> lifecyclePolicies) {
            this.lifecyclePolicies = LifecyclePoliciesCopier.copyFromBuilder(lifecyclePolicies);
        }

        @Override
        public PutLifecycleConfigurationResponse build() {
            return new PutLifecycleConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
