/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the directory on the Amazon EFS file system that the access point provides access to. The access point
 * exposes the specified file system path as the root directory of your file system to applications using the access
 * point. NFS clients using the access point can only access data in the access point's <code>RootDirectory</code> and
 * it's subdirectories.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RootDirectory implements SdkPojo, Serializable, ToCopyableBuilder<RootDirectory.Builder, RootDirectory> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(RootDirectory::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<CreationInfo> CREATION_INFO_FIELD = SdkField.<CreationInfo> builder(MarshallingType.SDK_POJO)
            .memberName("CreationInfo").getter(getter(RootDirectory::creationInfo)).setter(setter(Builder::creationInfo))
            .constructor(CreationInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD,
            CREATION_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String path;

    private final CreationInfo creationInfo;

    private RootDirectory(BuilderImpl builder) {
        this.path = builder.path;
        this.creationInfo = builder.creationInfo;
    }

    /**
     * <p>
     * Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access point
     * to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist,
     * you are required to provide the <code>CreationInfo</code>.
     * </p>
     * 
     * @return Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access
     *         point to access the EFS file system. A path can have up to four subdirectories. If the specified path
     *         does not exist, you are required to provide the <code>CreationInfo</code>.
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * (Optional) Specifies the POSIX IDs and permissions to apply to the access point's <code>RootDirectory</code>. If
     * the <code>RootDirectory</code> &gt; <code>Path</code> specified does not exist, EFS creates the root directory
     * using the <code>CreationInfo</code> settings when a client connects to an access point. When specifying the
     * <code>CreationInfo</code>, you must provide values for all properties.
     * </p>
     * <important>
     * <p>
     * If you do not provide <code>CreationInfo</code> and the specified <code>RootDirectory</code> &gt;
     * <code>Path</code> does not exist, attempts to mount the file system using the access point will fail.
     * </p>
     * </important>
     * 
     * @return (Optional) Specifies the POSIX IDs and permissions to apply to the access point's
     *         <code>RootDirectory</code>. If the <code>RootDirectory</code> &gt; <code>Path</code> specified does not
     *         exist, EFS creates the root directory using the <code>CreationInfo</code> settings when a client connects
     *         to an access point. When specifying the <code>CreationInfo</code>, you must provide values for all
     *         properties. </p> <important>
     *         <p>
     *         If you do not provide <code>CreationInfo</code> and the specified <code>RootDirectory</code> &gt;
     *         <code>Path</code> does not exist, attempts to mount the file system using the access point will fail.
     *         </p>
     */
    public CreationInfo creationInfo() {
        return creationInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(creationInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RootDirectory)) {
            return false;
        }
        RootDirectory other = (RootDirectory) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(creationInfo(), other.creationInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RootDirectory").add("Path", path()).add("CreationInfo", creationInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "CreationInfo":
            return Optional.ofNullable(clazz.cast(creationInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RootDirectory, T> g) {
        return obj -> g.apply((RootDirectory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RootDirectory> {
        /**
         * <p>
         * Specifies the path on the EFS file system to expose as the root directory to NFS clients using the access
         * point to access the EFS file system. A path can have up to four subdirectories. If the specified path does
         * not exist, you are required to provide the <code>CreationInfo</code>.
         * </p>
         * 
         * @param path
         *        Specifies the path on the EFS file system to expose as the root directory to NFS clients using the
         *        access point to access the EFS file system. A path can have up to four subdirectories. If the
         *        specified path does not exist, you are required to provide the <code>CreationInfo</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * (Optional) Specifies the POSIX IDs and permissions to apply to the access point's <code>RootDirectory</code>.
         * If the <code>RootDirectory</code> &gt; <code>Path</code> specified does not exist, EFS creates the root
         * directory using the <code>CreationInfo</code> settings when a client connects to an access point. When
         * specifying the <code>CreationInfo</code>, you must provide values for all properties.
         * </p>
         * <important>
         * <p>
         * If you do not provide <code>CreationInfo</code> and the specified <code>RootDirectory</code> &gt;
         * <code>Path</code> does not exist, attempts to mount the file system using the access point will fail.
         * </p>
         * </important>
         * 
         * @param creationInfo
         *        (Optional) Specifies the POSIX IDs and permissions to apply to the access point's
         *        <code>RootDirectory</code>. If the <code>RootDirectory</code> &gt; <code>Path</code> specified does
         *        not exist, EFS creates the root directory using the <code>CreationInfo</code> settings when a client
         *        connects to an access point. When specifying the <code>CreationInfo</code>, you must provide values
         *        for all properties. </p> <important>
         *        <p>
         *        If you do not provide <code>CreationInfo</code> and the specified <code>RootDirectory</code> &gt;
         *        <code>Path</code> does not exist, attempts to mount the file system using the access point will fail.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationInfo(CreationInfo creationInfo);

        /**
         * <p>
         * (Optional) Specifies the POSIX IDs and permissions to apply to the access point's <code>RootDirectory</code>.
         * If the <code>RootDirectory</code> &gt; <code>Path</code> specified does not exist, EFS creates the root
         * directory using the <code>CreationInfo</code> settings when a client connects to an access point. When
         * specifying the <code>CreationInfo</code>, you must provide values for all properties.
         * </p>
         * <important>
         * <p>
         * If you do not provide <code>CreationInfo</code> and the specified <code>RootDirectory</code> &gt;
         * <code>Path</code> does not exist, attempts to mount the file system using the access point will fail.
         * </p>
         * </important> This is a convenience that creates an instance of the {@link CreationInfo.Builder} avoiding the
         * need to create one manually via {@link CreationInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreationInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #creationInfo(CreationInfo)}.
         * 
         * @param creationInfo
         *        a consumer that will call methods on {@link CreationInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creationInfo(CreationInfo)
         */
        default Builder creationInfo(Consumer<CreationInfo.Builder> creationInfo) {
            return creationInfo(CreationInfo.builder().applyMutation(creationInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private CreationInfo creationInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(RootDirectory model) {
            path(model.path);
            creationInfo(model.creationInfo);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final CreationInfo.Builder getCreationInfo() {
            return creationInfo != null ? creationInfo.toBuilder() : null;
        }

        @Override
        public final Builder creationInfo(CreationInfo creationInfo) {
            this.creationInfo = creationInfo;
            return this;
        }

        public final void setCreationInfo(CreationInfo.BuilderImpl creationInfo) {
            this.creationInfo = creationInfo != null ? creationInfo.build() : null;
        }

        @Override
        public RootDirectory build() {
            return new RootDirectory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
