/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.efs.model.EfsRequest;
import software.amazon.awssdk.services.efs.model.PerformanceMode;
import software.amazon.awssdk.services.efs.model.Tag;
import software.amazon.awssdk.services.efs.model.TagsCopier;
import software.amazon.awssdk.services.efs.model.ThroughputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFileSystemRequest
extends EfsRequest
implements ToCopyableBuilder<Builder, CreateFileSystemRequest> {
    private static final SdkField<String> CREATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationToken").getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::creationToken)).setter(CreateFileSystemRequest.setter(Builder::creationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> PERFORMANCE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformanceMode").getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::performanceModeAsString)).setter(CreateFileSystemRequest.setter(Builder::performanceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceMode").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::encrypted)).setter(CreateFileSystemRequest.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::kmsKeyId)).setter(CreateFileSystemRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> THROUGHPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThroughputMode").getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::throughputModeAsString)).setter(CreateFileSystemRequest.setter(Builder::throughputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputMode").build()}).build();
    private static final SdkField<Double> PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ProvisionedThroughputInMibps").getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::provisionedThroughputInMibps)).setter(CreateFileSystemRequest.setter(Builder::provisionedThroughputInMibps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputInMibps").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFileSystemRequest.getter(CreateFileSystemRequest::tags)).setter(CreateFileSystemRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TOKEN_FIELD, PERFORMANCE_MODE_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, THROUGHPUT_MODE_FIELD, PROVISIONED_THROUGHPUT_IN_MIBPS_FIELD, TAGS_FIELD));
    private final String creationToken;
    private final String performanceMode;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String throughputMode;
    private final Double provisionedThroughputInMibps;
    private final List<Tag> tags;

    private CreateFileSystemRequest(BuilderImpl builder) {
        super(builder);
        this.creationToken = builder.creationToken;
        this.performanceMode = builder.performanceMode;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.throughputMode = builder.throughputMode;
        this.provisionedThroughputInMibps = builder.provisionedThroughputInMibps;
        this.tags = builder.tags;
    }

    public String creationToken() {
        return this.creationToken;
    }

    public PerformanceMode performanceMode() {
        return PerformanceMode.fromValue(this.performanceMode);
    }

    public String performanceModeAsString() {
        return this.performanceMode;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public ThroughputMode throughputMode() {
        return ThroughputMode.fromValue(this.throughputMode);
    }

    public String throughputModeAsString() {
        return this.throughputMode;
    }

    public Double provisionedThroughputInMibps() {
        return this.provisionedThroughputInMibps;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputInMibps());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemRequest)) {
            return false;
        }
        CreateFileSystemRequest other = (CreateFileSystemRequest)((Object)obj);
        return Objects.equals(this.creationToken(), other.creationToken()) && Objects.equals(this.performanceModeAsString(), other.performanceModeAsString()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.throughputModeAsString(), other.throughputModeAsString()) && Objects.equals(this.provisionedThroughputInMibps(), other.provisionedThroughputInMibps()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateFileSystemRequest").add("CreationToken", (Object)this.creationToken()).add("PerformanceMode", (Object)this.performanceModeAsString()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ThroughputMode", (Object)this.throughputModeAsString()).add("ProvisionedThroughputInMibps", (Object)this.provisionedThroughputInMibps()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationToken": {
                return Optional.ofNullable(clazz.cast(this.creationToken()));
            }
            case "PerformanceMode": {
                return Optional.ofNullable(clazz.cast(this.performanceModeAsString()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ThroughputMode": {
                return Optional.ofNullable(clazz.cast(this.throughputModeAsString()));
            }
            case "ProvisionedThroughputInMibps": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputInMibps()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemRequest, T> g) {
        return obj -> g.apply((CreateFileSystemRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EfsRequest.BuilderImpl
    implements Builder {
        private String creationToken;
        private String performanceMode;
        private Boolean encrypted;
        private String kmsKeyId;
        private String throughputMode;
        private Double provisionedThroughputInMibps;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemRequest model) {
            super(model);
            this.creationToken(model.creationToken);
            this.performanceMode(model.performanceMode);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.throughputMode(model.throughputMode);
            this.provisionedThroughputInMibps(model.provisionedThroughputInMibps);
            this.tags(model.tags);
        }

        public final String getCreationToken() {
            return this.creationToken;
        }

        @Override
        public final Builder creationToken(String creationToken) {
            this.creationToken = creationToken;
            return this;
        }

        public final void setCreationToken(String creationToken) {
            this.creationToken = creationToken;
        }

        public final String getPerformanceMode() {
            return this.performanceMode;
        }

        @Override
        public final Builder performanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
            return this;
        }

        @Override
        public final Builder performanceMode(PerformanceMode performanceMode) {
            this.performanceMode(performanceMode == null ? null : performanceMode.toString());
            return this;
        }

        public final void setPerformanceMode(String performanceMode) {
            this.performanceMode = performanceMode;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getThroughputMode() {
            return this.throughputMode;
        }

        @Override
        public final Builder throughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @Override
        public final Builder throughputMode(ThroughputMode throughputMode) {
            this.throughputMode(throughputMode == null ? null : throughputMode.toString());
            return this;
        }

        public final void setThroughputMode(String throughputMode) {
            this.throughputMode = throughputMode;
        }

        public final Double getProvisionedThroughputInMibps() {
            return this.provisionedThroughputInMibps;
        }

        @Override
        public final Builder provisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
            return this;
        }

        public final void setProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
            this.provisionedThroughputInMibps = provisionedThroughputInMibps;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFileSystemRequest build() {
            return new CreateFileSystemRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EfsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFileSystemRequest> {
        public Builder creationToken(String var1);

        public Builder performanceMode(String var1);

        public Builder performanceMode(PerformanceMode var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder throughputMode(String var1);

        public Builder throughputMode(ThroughputMode var1);

        public Builder provisionedThroughputInMibps(Double var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

