/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccessPointsResponse extends EfsResponse implements
        ToCopyableBuilder<DescribeAccessPointsResponse.Builder, DescribeAccessPointsResponse> {
    private static final SdkField<List<AccessPointDescription>> ACCESS_POINTS_FIELD = SdkField
            .<List<AccessPointDescription>> builder(MarshallingType.LIST)
            .memberName("AccessPoints")
            .getter(getter(DescribeAccessPointsResponse::accessPoints))
            .setter(setter(Builder::accessPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccessPointDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessPointDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAccessPointsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AccessPointDescription> accessPoints;

    private final String nextToken;

    private DescribeAccessPointsResponse(BuilderImpl builder) {
        super(builder);
        this.accessPoints = builder.accessPoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AccessPoints property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAccessPoints() {
        return accessPoints != null && !(accessPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of access point descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccessPoints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of access point descriptions.
     */
    public final List<AccessPointDescription> accessPoints() {
        return accessPoints;
    }

    /**
     * <p>
     * Present if there are more access points than returned in the response. You can use the NextMarker in the
     * subsequent request to fetch the additional descriptions.
     * </p>
     * 
     * @return Present if there are more access points than returned in the response. You can use the NextMarker in the
     *         subsequent request to fetch the additional descriptions.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessPoints() ? accessPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccessPointsResponse)) {
            return false;
        }
        DescribeAccessPointsResponse other = (DescribeAccessPointsResponse) obj;
        return hasAccessPoints() == other.hasAccessPoints() && Objects.equals(accessPoints(), other.accessPoints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccessPointsResponse").add("AccessPoints", hasAccessPoints() ? accessPoints() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessPoints":
            return Optional.ofNullable(clazz.cast(accessPoints()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccessPointsResponse, T> g) {
        return obj -> g.apply((DescribeAccessPointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EfsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAccessPointsResponse> {
        /**
         * <p>
         * An array of access point descriptions.
         * </p>
         * 
         * @param accessPoints
         *        An array of access point descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPoints(Collection<AccessPointDescription> accessPoints);

        /**
         * <p>
         * An array of access point descriptions.
         * </p>
         * 
         * @param accessPoints
         *        An array of access point descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPoints(AccessPointDescription... accessPoints);

        /**
         * <p>
         * An array of access point descriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccessPointDescription>.Builder} avoiding
         * the need to create one manually via {@link List<AccessPointDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccessPointDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #accessPoints(List<AccessPointDescription>)}.
         * 
         * @param accessPoints
         *        a consumer that will call methods on {@link List<AccessPointDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPoints(List<AccessPointDescription>)
         */
        Builder accessPoints(Consumer<AccessPointDescription.Builder>... accessPoints);

        /**
         * <p>
         * Present if there are more access points than returned in the response. You can use the NextMarker in the
         * subsequent request to fetch the additional descriptions.
         * </p>
         * 
         * @param nextToken
         *        Present if there are more access points than returned in the response. You can use the NextMarker in
         *        the subsequent request to fetch the additional descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private List<AccessPointDescription> accessPoints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccessPointsResponse model) {
            super(model);
            accessPoints(model.accessPoints);
            nextToken(model.nextToken);
        }

        public final Collection<AccessPointDescription.Builder> getAccessPoints() {
            if (accessPoints instanceof SdkAutoConstructList) {
                return null;
            }
            return accessPoints != null ? accessPoints.stream().map(AccessPointDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessPoints(Collection<AccessPointDescription> accessPoints) {
            this.accessPoints = AccessPointDescriptionsCopier.copy(accessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(AccessPointDescription... accessPoints) {
            accessPoints(Arrays.asList(accessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(Consumer<AccessPointDescription.Builder>... accessPoints) {
            accessPoints(Stream.of(accessPoints).map(c -> AccessPointDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccessPoints(Collection<AccessPointDescription.BuilderImpl> accessPoints) {
            this.accessPoints = AccessPointDescriptionsCopier.copyFromBuilder(accessPoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAccessPointsResponse build() {
            return new DescribeAccessPointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
